/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.ibatis.cache.CacheException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.mybatis.caches.memcached.CompressorTranscoder;
import org.mybatis.caches.memcached.MemcachedCache;
import org.mybatis.caches.memcached.MemcachedConfiguration;
import org.mybatis.caches.memcached.MemcachedConfigurationBuilder;
import org.mybatis.caches.memcached.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MemcachedClientWrapper {
    private final Log log = LogFactory.getLog(MemcachedCache.class);
    private final MemcachedConfiguration configuration = MemcachedConfigurationBuilder.getInstance().parseConfiguration();
    private final MemcachedClient client;

    public MemcachedClientWrapper() {
        try {
            this.client = new MemcachedClient(this.configuration.getConnectionFactory(), this.configuration.getAddresses());
        }
        catch (IOException e) {
            String message = "Impossible to instantiate a new memecached client instance, see nested exceptions";
            this.log.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Running new Memcached client using " + this.configuration);
        }
    }

    private String toKeyString(Object key) {
        String keyString = this.configuration.getKeyPrefix() + StringUtils.sha1Hex(key.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Object key '" + key + "' converted in '" + keyString + "'");
        }
        return keyString;
    }

    public Object getObject(Object key) {
        String keyString = this.toKeyString(key);
        Object ret = this.retrieve(keyString);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Retrived object (" + keyString + ", " + ret + ")");
        }
        return ret;
    }

    private Set<String> getGroup(String groupKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Retrieving group with id '" + groupKey + "'");
        }
        Object groups = null;
        try {
            groups = this.retrieve(groupKey);
        }
        catch (Exception e) {
            this.log.error("Impossible to retrieve group '" + groupKey + "' see nested exceptions", (Throwable)e);
        }
        if (groups == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Group '" + groupKey + "' not previously stored");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("retrieved group '" + groupKey + "' with values " + groups);
        }
        return (Set)groups;
    }

    private Object retrieve(String keyString) {
        Object retrieved = null;
        if (this.configuration.isUsingAsyncGet()) {
            GetFuture future = this.configuration.isCompressionEnabled() ? this.client.asyncGet(keyString, (Transcoder)new CompressorTranscoder()) : this.client.asyncGet(keyString);
            try {
                retrieved = future.get(this.configuration.getTimeout(), this.configuration.getTimeUnit());
            }
            catch (Exception e) {
                future.cancel(false);
                throw new CacheException((Throwable)e);
            }
        } else {
            retrieved = this.configuration.isCompressionEnabled() ? this.client.get(keyString, (Transcoder)new CompressorTranscoder()) : this.client.get(keyString);
        }
        return retrieved;
    }

    public void putObject(Object key, Object value, String id) {
        String keyString = this.toKeyString(key);
        String groupKey = this.toKeyString(id);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Putting object (" + keyString + ", " + value + ")");
        }
        this.storeInMemcached(keyString, value);
        Set<String> group = this.getGroup(groupKey);
        if (group == null) {
            group = new HashSet<String>();
        }
        group.add(keyString);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Insert/Updating object (" + groupKey + ", " + group + ")");
        }
        this.storeInMemcached(groupKey, group);
    }

    private void storeInMemcached(String keyString, Object value) {
        if (value != null && !Serializable.class.isAssignableFrom(value.getClass())) {
            throw new CacheException("Object of type '" + value.getClass().getName() + "' that's non-serializable is not supported by Memcached");
        }
        if (this.configuration.isCompressionEnabled()) {
            this.client.set(keyString, this.configuration.getExpiration(), value, (Transcoder)new CompressorTranscoder());
        } else {
            this.client.set(keyString, this.configuration.getExpiration(), value);
        }
    }

    public Object removeObject(Object key) {
        Object result;
        String keyString = this.toKeyString(key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing object '" + keyString + "'");
        }
        if ((result = this.getObject(key)) != null) {
            this.client.delete(keyString);
        }
        return result;
    }

    public void removeGroup(String id) {
        String groupKey = this.toKeyString(id);
        Set<String> group = this.getGroup(groupKey);
        if (group == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No need to flush cached entries for group '" + id + "' because is empty");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flushing keys: " + group);
        }
        for (String key : group) {
            this.client.delete(key);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flushing group: " + groupKey);
        }
        this.client.delete(groupKey);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.client.shutdown((long)this.configuration.getTimeout(), this.configuration.getTimeUnit());
    }
}

