/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.ibatis.cache.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompressorTranscoder
implements Transcoder<Object> {
    private static final int SERIALIZED_COMPRESSED = 3;

    CompressorTranscoder() {
    }

    public boolean asyncDecode(CachedData cachedData) {
        return false;
    }

    public Object decode(CachedData cachedData) {
        byte[] buffer = cachedData.getData();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        GZIPInputStream gzis = null;
        ObjectInputStream ois = null;
        Object ret = null;
        try {
            gzis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gzis);
            ret = ois.readObject();
        }
        catch (Exception e) {
            try {
                throw new CacheException("Impossible to decompress cached object, see nested exceptions", (Throwable)e);
            }
            catch (Throwable throwable) {
                CompressorTranscoder.closeQuietly(ois);
                CompressorTranscoder.closeQuietly(gzis);
                CompressorTranscoder.closeQuietly(bais);
                throw throwable;
            }
        }
        CompressorTranscoder.closeQuietly(ois);
        CompressorTranscoder.closeQuietly(gzis);
        CompressorTranscoder.closeQuietly(bais);
        return ret;
    }

    public CachedData encode(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzops = null;
        ObjectOutputStream oos = null;
        try {
            gzops = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gzops);
            oos.writeObject(object);
        }
        catch (IOException e) {
            try {
                throw new CacheException("Impossible to compress object [" + object + "], see nested exceptions", (Throwable)e);
            }
            catch (Throwable throwable) {
                CompressorTranscoder.closeQuietly(oos);
                CompressorTranscoder.closeQuietly(gzops);
                CompressorTranscoder.closeQuietly(baos);
                throw throwable;
            }
        }
        CompressorTranscoder.closeQuietly(oos);
        CompressorTranscoder.closeQuietly(gzops);
        CompressorTranscoder.closeQuietly(baos);
        byte[] buffer = baos.toByteArray();
        return new CachedData(3, buffer, 0x1400000);
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

