/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.valueaccess;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.CopyOnWriteLinkedHashMap;
import org.modelmapper.internal.util.TypeResolver;
import org.modelmapper.internal.valueaccess.MapValueReader;
import org.modelmapper.spi.ValueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueAccessStore {
    private final TypeResolvingList<ValueReader<?>> valueReaders = new TypeResolvingList<ValueReader>(ValueReader.class);

    public ValueAccessStore() {
        this.valueReaders.add(new MapValueReader());
    }

    public <T> ValueReader<T> getFirstSupportedReader(Class<T> type) {
        for (Map.Entry entry : ((TypeResolvingList)this.valueReaders).valueAccessors.entrySet()) {
            if (!((Class)entry.getValue()).isAssignableFrom(type)) continue;
            return (ValueReader)entry.getKey();
        }
        return null;
    }

    public List<ValueReader<?>> getValueReaders() {
        return this.valueReaders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeResolvingList<T>
    extends CopyOnWriteArrayList<T> {
        private static final long serialVersionUID = 1252949487997828943L;
        private final Map<T, Class<?>> valueAccessors = new CopyOnWriteLinkedHashMap();
        private final Class<? super T> valueAccessorType;

        TypeResolvingList(Class<? super T> valueAccessorType) {
            this.valueAccessorType = valueAccessorType;
        }

        @Override
        public void add(int index, T element) {
            this.putValueAccessor(element);
            super.add(index, element);
        }

        @Override
        public boolean add(T element) {
            this.putValueAccessor(element);
            return super.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean changed = false;
            for (T e : c) {
                this.putValueAccessor(e);
                changed = super.add(e);
            }
            return changed;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.valueAccessors.clear();
            super.clear();
        }

        @Override
        public T remove(int index) {
            Object result = super.remove(index);
            this.valueAccessors.remove(result);
            return (T)result;
        }

        @Override
        public boolean remove(Object o) {
            this.valueAccessors.remove(o);
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = super.removeAll(c);
            for (Object e : c) {
                this.valueAccessors.remove(e);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            this.putValueAccessor(element);
            return super.set(index, element);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        private void putValueAccessor(T valueAccessor) {
            Assert.notNull(valueAccessor, "element");
            Class<?> typeArgument = TypeResolver.resolveArgument(valueAccessor.getClass(), this.valueAccessorType);
            Assert.notNull(typeArgument, "Must declare source type argument <T> for the " + this.valueAccessorType.getSimpleName());
            this.valueAccessors.put(valueAccessor, typeArgument);
        }
    }
}

