/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.modelmapper.internal.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Types {
    private static Class<?> JAVASSIST_PROXY_FACTORY_CLASS;
    private static Method JAVASSIST_IS_PROXY_CLASS_METHOD;

    public static <T> Class<T> deProxy(Class<?> type) {
        if (type.isInterface()) {
            return type;
        }
        boolean isProxy = false;
        if (type.getName().contains("$$EnhancerBy")) {
            isProxy = true;
        }
        if (Proxy.isProxyClass(type)) {
            isProxy = true;
        }
        try {
            if (JAVASSIST_IS_PROXY_CLASS_METHOD != null && JAVASSIST_IS_PROXY_CLASS_METHOD != null && ((Boolean)JAVASSIST_IS_PROXY_CLASS_METHOD.invoke(null, type)).booleanValue()) {
                isProxy = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isProxy) {
            Class<?> superclass = type.getSuperclass();
            if (!superclass.equals(Object.class) && !superclass.equals(Proxy.class)) {
                return superclass;
            }
            Class<?>[] interfaces = type.getInterfaces();
            if (interfaces.length > 0) {
                return interfaces[0];
            }
        }
        return type;
    }

    public static boolean isGroovyType(Class<?> type) {
        return type.getName().startsWith("org.codehaus.groovy");
    }

    public static boolean isInstantiable(Class<?> type) {
        return !type.isEnum() && !type.isAssignableFrom(String.class) && !Primitives.isPrimitiveWrapper(type);
    }

    public static Class<?> rawTypeFor(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.rawTypeFor(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Types.rawTypeFor(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return Types.rawTypeFor(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Could not determine raw type for " + className);
    }

    public static String toString(Member member) {
        if (member instanceof Method) {
            return member.getDeclaringClass().getName() + "." + member.getName() + "()";
        }
        if (member instanceof Field) {
            return member.getDeclaringClass().getName() + "." + member.getName();
        }
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getName() + ".<init>()";
        }
        return null;
    }

    public static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    static {
        try {
            JAVASSIST_PROXY_FACTORY_CLASS = Types.class.getClassLoader().loadClass("javassist.util.proxy.ProxyFactory");
            JAVASSIST_IS_PROXY_CLASS_METHOD = JAVASSIST_PROXY_FACTORY_CLASS.getMethod("isProxyClass", Class.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

