/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import org.modelmapper.internal.converter.IterableConverter;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayConverter
extends IterableConverter<Object, Object> {
    ArrayConverter() {
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Iterables.isIterable(sourceType) && destinationType.isArray() ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    @Override
    protected void setElement(Object destination, Object element, int index) {
        Array.set(destination, index, element);
    }

    @Override
    protected Class<?> getElementType(MappingContext<Object, Object> context) {
        if (context.getGenericDestinationType() instanceof GenericArrayType) {
            return Types.rawTypeFor((GenericArrayType)context.getGenericDestinationType()).getComponentType();
        }
        return context.getDestinationType().getComponentType();
    }

    @Override
    protected Object createDestination(MappingContext<Object, Object> context, int length) {
        Class<Object> destType = context.getDestinationType();
        return Array.newInstance(destType.isArray() ? destType.getComponentType() : destType, length);
    }
}

