/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.List;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMappingImpl
extends MappingImpl
implements PropertyMapping {
    protected final List<PropertyInfo> sourceAccessors;
    protected boolean cyclic;

    PropertyMappingImpl(List<? extends PropertyInfo> sourceAccessors, List<? extends PropertyInfo> destinationMutators, boolean cyclic) {
        super(destinationMutators);
        this.sourceAccessors = new ArrayList<PropertyInfo>(sourceAccessors);
        this.cyclic = cyclic;
    }

    PropertyMappingImpl(List<? extends PropertyInfo> sourceAccessors, List<? extends PropertyInfo> destinationMutators, Provider<?> provider, Converter<?, ?> converter) {
        super(destinationMutators);
        this.provider = provider;
        this.converter = converter;
        this.sourceAccessors = new ArrayList<PropertyInfo>(sourceAccessors);
    }

    PropertyMappingImpl(List<? extends PropertyInfo> sourceAccessors, List<Mutator> destinationMutators, ExplicitMappingBuilder.MappingOptions options) {
        super(destinationMutators, options);
        this.sourceAccessors = new ArrayList<PropertyInfo>(sourceAccessors);
    }

    PropertyMappingImpl(PropertyMappingImpl mapping, List<? extends PropertyInfo> mergedAccessors, List<? extends PropertyInfo> mergedMutators) {
        super(mapping, mergedMutators);
        this.sourceAccessors = new ArrayList<PropertyInfo>(mapping.sourceAccessors.size() + (mergedAccessors == null ? 0 : mergedAccessors.size()));
        this.sourceAccessors.addAll(mergedAccessors);
        this.sourceAccessors.addAll(mapping.sourceAccessors);
        this.cyclic = mapping.cyclic;
    }

    @Override
    public PropertyInfo getLastSourceProperty() {
        return this.sourceAccessors == null || this.sourceAccessors.isEmpty() ? null : this.sourceAccessors.get(this.sourceAccessors.size() - 1);
    }

    @Override
    public List<? extends PropertyInfo> getSourceProperties() {
        return this.sourceAccessors;
    }

    public String toString() {
        return String.format("PropertyMapping[%s -> %s]", Strings.joinWithFirstType(this.sourceAccessors), Strings.joinWithFirstType(this.destinationMutators));
    }

    @Override
    MappingImpl createMergedCopy(List<? extends PropertyInfo> mergedAccessors, List<? extends PropertyInfo> mergedMutators) {
        return new PropertyMappingImpl(this, mergedAccessors, mergedMutators);
    }
}

