/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.spi.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyInfoRegistry {
    private static final Map<Integer, PropertyInfo> cache = new ConcurrentHashMap<Integer, PropertyInfo>();

    PropertyInfoRegistry() {
    }

    private static Integer hashCodeFor(Class<?> initialType, String propertyName, Configuration configuration) {
        int result = 31 + initialType.hashCode();
        result = 31 * result + propertyName.hashCode();
        result = 31 * result + configuration.hashCode();
        return result;
    }

    static Accessor accessorFor(Class<?> type, String accessorName, Configuration configuration) {
        return (Accessor)cache.get(PropertyInfoRegistry.hashCodeFor(type, accessorName, configuration));
    }

    static synchronized Accessor accessorFor(Class<?> type, Method method, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, method.getName(), configuration);
        Accessor accessor = (Accessor)cache.get(hashCode);
        if (accessor == null) {
            accessor = new PropertyInfoImpl.MethodAccessor(type, method, name);
            cache.put(hashCode, accessor);
        }
        return accessor;
    }

    static synchronized PropertyInfoImpl.FieldPropertyInfo fieldPropertyFor(Class<?> type, Field field, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, field.getName(), configuration);
        PropertyInfoImpl.FieldPropertyInfo fieldPropertyInfo = (PropertyInfoImpl.FieldPropertyInfo)cache.get(hashCode);
        if (fieldPropertyInfo == null) {
            fieldPropertyInfo = new PropertyInfoImpl.FieldPropertyInfo(type, field, name);
            cache.put(hashCode, fieldPropertyInfo);
        }
        return fieldPropertyInfo;
    }

    static synchronized Mutator mutatorFor(Class<?> type, Method method, Configuration configuration, String name) {
        Integer hashCode = PropertyInfoRegistry.hashCodeFor(type, method.getName(), configuration);
        Mutator mutator = (Mutator)cache.get(hashCode);
        if (mutator == null) {
            mutator = new PropertyInfoImpl.MethodMutator(type, method, name);
            cache.put(hashCode, mutator);
        }
        return mutator;
    }
}

