/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.Condition;
import org.modelmapper.ConfigurationException;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.TypeMap;
import org.modelmapper.TypeToken;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingContextImpl;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.ProvisionRequestImpl;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.TypeMapStore;
import org.modelmapper.internal.TypePair;
import org.modelmapper.internal.converter.ConverterStore;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConstantMapping;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.MappingEngine;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;
import org.modelmapper.spi.SourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingEngineImpl
implements MappingEngine {
    private final Map<TypePair<?, ?>, Converter<?, ?>> converterCache = new ConcurrentHashMap();
    private final InheritingConfiguration configuration;
    private final TypeMapStore typeMapStore;
    private final ConverterStore converterStore;

    public MappingEngineImpl(InheritingConfiguration configuration) {
        this.configuration = configuration;
        this.typeMapStore = configuration.typeMapStore;
        this.converterStore = configuration.converterStore;
    }

    public <S, D> D map(S source, Class<S> sourceType, D destination, TypeToken<D> destinationTypeToken, String typeMapName) {
        MappingContextImpl<S, D> context = new MappingContextImpl<S, D>(source, sourceType, destination, destinationTypeToken.getRawType(), destinationTypeToken.getType(), typeMapName, this);
        D result = null;
        try {
            result = this.map(context);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (ErrorsException e) {
            throw context.errors.toMappingException();
        }
        catch (Throwable t) {
            context.errors.errorMapping(sourceType, destinationTypeToken.getType(), t);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
        return result;
    }

    @Override
    public <S, D> D map(MappingContext<S, D> context) {
        Object circularDest;
        MappingContextImpl contextImpl = (MappingContextImpl)context;
        Class<D> destinationType = context.getDestinationType();
        if (!Iterables.isIterable(destinationType) && (circularDest = contextImpl.destinationForSource()) != null && circularDest.getClass().isAssignableFrom(contextImpl.getDestinationType())) {
            return circularDest;
        }
        D destination = null;
        TypeMap<S, D> typeMap = this.typeMapStore.get(context.getSourceType(), context.getDestinationType(), context.getTypeMapName());
        if (typeMap != null) {
            destination = this.typeMap(contextImpl, typeMap);
        } else {
            Converter<S, D> converter = this.converterFor(context);
            if (converter != null && (context.getDestination() == null || context.getParent() != null)) {
                destination = this.convert(context, converter);
            } else {
                typeMap = this.typeMapStore.getOrCreate(context.getSource(), context.getSourceType(), context.getDestinationType(), context.getTypeMapName(), this);
                destination = this.typeMap(contextImpl, typeMap);
            }
        }
        contextImpl.setDestination(destination, true);
        return destination;
    }

    <S, D> D typeMap(MappingContextImpl<S, D> context, TypeMap<S, D> typeMap) {
        D destination;
        context.setTypeMap(typeMap);
        if (context.getDestination() == null && Types.isInstantiable(context.getDestinationType()) && (destination = this.createDestination(context)) == null) {
            return null;
        }
        Condition<?, ?> condition = typeMap.getCondition();
        Converter<S, D> converter = typeMap.getConverter();
        if (condition == null || condition.applies(context)) {
            if (converter != null) {
                return this.convert(context, converter);
            }
            converter = typeMap.getPreConverter();
            if (converter != null) {
                context.setDestination(this.convert(context, converter), true);
            }
            for (Mapping mapping : typeMap.getMappings()) {
                this.propertyMap(mapping, context);
            }
            converter = typeMap.getPostConverter();
            if (converter != null) {
                this.convert(context, converter);
            }
        }
        return context.getDestination();
    }

    private <S, D> void propertyMap(Mapping mapping, MappingContextImpl<S, D> context) {
        Converter<Object, Object> converter;
        MappingImpl mappingImpl = (MappingImpl)mapping;
        String propertyPath = context.destinationPath + mappingImpl.getPath();
        if (context.isShaded(propertyPath)) {
            return;
        }
        Condition<?, ?> condition = mapping.getCondition();
        if (condition == null) {
            condition = context.getTypeMap().getPropertyCondition();
        }
        if (condition == null) {
            condition = this.configuration.getPropertyCondition();
        }
        if (condition == null && mapping.isSkipped()) {
            return;
        }
        Object source = this.resolveSourceValue(context, mapping);
        MappingContextImpl<Object, Object> propertyContext = this.propertyContextFor(context, source, mappingImpl);
        if (condition != null) {
            if (!condition.applies(propertyContext)) {
                context.shadePath(propertyPath);
                return;
            }
            if (mapping.isSkipped()) {
                return;
            }
        }
        if ((converter = mapping.getConverter()) == null) {
            converter = context.getTypeMap().getPropertyConverter();
        }
        if (converter != null) {
            context.shadePath(propertyPath);
        } else if (mapping instanceof SourceMapping) {
            return;
        }
        this.createDestinationViaProvider(propertyContext);
        this.setDestinationValue(context, propertyContext, mappingImpl, converter);
    }

    private Object resolveSourceValue(MappingContextImpl<?, ?> context, Mapping mapping) {
        Object source = context.getSource();
        if (mapping instanceof PropertyMappingImpl) {
            for (Accessor accessor : ((PropertyMapping)mapping).getSourceProperties()) {
                Object circularDest;
                context.setParentSource(source);
                source = accessor.getValue(source);
                if (source == null) {
                    return null;
                }
                if (Iterables.isIterable(source.getClass()) || (circularDest = context.sourceToDestination.get(source)) == null) continue;
                context.intermediateDestinations.add(circularDest);
            }
        } else if (mapping instanceof ConstantMapping) {
            source = ((ConstantMapping)mapping).getConstant();
        }
        return source;
    }

    private void setDestinationValue(MappingContextImpl<?, ?> context, MappingContextImpl<Object, Object> propertyContext, MappingImpl mapping, Converter<Object, Object> converter) {
        Object destination = context.getDestination();
        List<? extends PropertyInfo> mutatorChain = mapping.getDestinationProperties();
        StringBuilder destPathBuilder = new StringBuilder();
        destPathBuilder.append(context.destinationPath);
        for (int i = 0; i < mutatorChain.size(); ++i) {
            Object accessor;
            Mutator mutator = (Mutator)mutatorChain.get(i);
            destPathBuilder.append(mutator.getName()).append('.');
            String destPath = destPathBuilder.toString();
            if (i == mutatorChain.size() - 1) {
                Object destinationValue = null;
                if (converter != null) {
                    if (context.providedDestination && (accessor = TypeInfoRegistry.typeInfoFor(destination.getClass(), this.configuration).getAccessors().get(mutator.getName())) != null) {
                        Object intermediateDest = accessor.getValue(destination);
                        propertyContext.setDestination(intermediateDest, true);
                    }
                    destinationValue = this.convert(propertyContext, converter);
                } else if (propertyContext.getSource() == null) {
                    converter = this.converterFor(propertyContext);
                    if (converter != null) {
                        destinationValue = this.convert(propertyContext, converter);
                    }
                } else {
                    destinationValue = this.map(propertyContext);
                }
                context.destinationCache.put(destPath, destinationValue);
                mutator.setValue(destination, destinationValue == null ? Primitives.defaultValue(mutator.getType()) : destinationValue);
                if (destinationValue != null) continue;
                context.shadePath(propertyContext.destinationPath);
                continue;
            }
            Object intermediateDest = context.destinationCache.get(destPath);
            if (intermediateDest != null) {
                mutator.setValue(destination, intermediateDest);
            } else {
                if (!context.intermediateDestinations.isEmpty()) {
                    accessor = context.intermediateDestinations.iterator();
                    while (accessor.hasNext()) {
                        Object intermediateDestination = accessor.next();
                        if (!intermediateDestination.getClass().equals(mutator.getType())) continue;
                        intermediateDest = intermediateDestination;
                        mutator.setValue(destination, intermediateDest);
                        break;
                    }
                }
                if (intermediateDest == null) {
                    if (context.providedDestination && (accessor = TypeInfoRegistry.typeInfoFor(destination.getClass(), this.configuration).getAccessors().get(mutator.getName())) != null) {
                        intermediateDest = accessor.getValue(destination);
                    }
                    if (intermediateDest == null) {
                        if (propertyContext.getSource() == null) {
                            return;
                        }
                        intermediateDest = this.createDestinationViaGlobalProvider(context.parentSource(), mutator.getType(), context.errors);
                        if (intermediateDest == null) {
                            return;
                        }
                        mutator.setValue(destination, intermediateDest);
                    }
                }
                context.destinationCache.put(destPath, intermediateDest);
            }
            destination = intermediateDest;
        }
    }

    private MappingContextImpl<Object, Object> propertyContextFor(MappingContextImpl<?, ?> context, Object source, MappingImpl mapping) {
        Class<Object> sourceType;
        boolean cyclic = false;
        if (mapping instanceof PropertyMapping) {
            PropertyMappingImpl propertyMapping = (PropertyMappingImpl)mapping;
            sourceType = propertyMapping.getLastSourceProperty().getType();
            cyclic = propertyMapping.cyclic;
        } else {
            Object constant;
            sourceType = mapping instanceof ConstantMapping ? ((constant = ((ConstantMapping)((Object)mapping)).getConstant()) == null ? Object.class : Types.deProxy(constant.getClass())) : ((SourceMapping)((Object)mapping)).getSourceType();
        }
        Class<?> destinationType = mapping.getLastDestinationProperty().getType();
        return new MappingContextImpl<Object, Object>(context, source, sourceType, null, destinationType, null, mapping, !cyclic);
    }

    private <S, D> D convert(MappingContext<S, D> context, Converter<S, D> converter) {
        try {
            return converter.convert(context);
        }
        catch (ErrorsException e) {
            throw e;
        }
        catch (Exception e) {
            ((MappingContextImpl)context).errors.errorConverting(converter, context.getSourceType(), context.getDestinationType(), e);
            return null;
        }
    }

    private <S, D> Converter<S, D> converterFor(MappingContext<S, D> context) {
        TypePair<S, D> typePair = TypePair.of(context.getSourceType(), context.getDestinationType(), context.getTypeMapName());
        Converter<?, ?> converter = this.converterCache.get(typePair);
        if (converter == null && (converter = this.converterStore.getFirstSupported(context.getSourceType(), context.getDestinationType())) != null) {
            this.converterCache.put(typePair, converter);
        }
        return converter;
    }

    private <T> T instantiate(Class<T> type, Errors errors) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            errors.errorInstantiatingDestination(type, e);
            return null;
        }
    }

    @Override
    public <S, D> D createDestination(MappingContext<S, D> context) {
        MappingContextImpl contextImpl = (MappingContextImpl)context;
        D destination = this.createDestinationViaProvider(contextImpl);
        if (destination != null) {
            return destination;
        }
        destination = this.instantiate(context.getDestinationType(), contextImpl.errors);
        contextImpl.setDestination(destination, true);
        return destination;
    }

    private <S, D> D createDestinationViaProvider(MappingContextImpl<S, D> context) {
        Provider<Object> provider = null;
        if (context.getMapping() != null && (provider = context.getMapping().getProvider()) == null && context.parentTypeMap() != null) {
            provider = context.parentTypeMap().getPropertyProvider();
        }
        if (provider == null && context.getTypeMap() != null) {
            provider = context.getTypeMap().getProvider();
        }
        if (provider == null && this.configuration.getProvider() != null) {
            provider = this.configuration.getProvider();
        }
        if (provider == null) {
            return null;
        }
        Object destination = provider.get(context);
        this.validateDestination(context.getDestinationType(), destination, context.errors);
        context.setDestination(destination, false);
        return (D)destination;
    }

    private <S, D> D createDestinationViaGlobalProvider(S source, Class<D> requestedType, Errors errors) {
        D destination = null;
        Provider<?> provider = this.configuration.getProvider();
        if (provider != null) {
            destination = (D)provider.get(new ProvisionRequestImpl<D>(source, requestedType));
            this.validateDestination(requestedType, destination, errors);
        }
        if (destination == null) {
            destination = this.instantiate(requestedType, errors);
        }
        return destination;
    }

    private void validateDestination(Class<?> destinationType, Object destination, Errors errors) {
        if (destination != null && !destinationType.isAssignableFrom(destination.getClass())) {
            errors.invalidProvidedDestinationInstance(destination, destinationType);
        }
    }
}

