/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyInfoRegistry;
import org.modelmapper.internal.PropertyInfoResolver;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.asm.ClassVisitor;
import org.modelmapper.internal.asm.FieldVisitor;
import org.modelmapper.internal.asm.Handle;
import org.modelmapper.internal.asm.MethodVisitor;
import org.modelmapper.internal.asm.Type;
import org.modelmapper.internal.asm.tree.AbstractInsnNode;
import org.modelmapper.internal.asm.tree.FieldInsnNode;
import org.modelmapper.internal.asm.tree.InsnNode;
import org.modelmapper.internal.asm.tree.InvokeDynamicInsnNode;
import org.modelmapper.internal.asm.tree.MethodInsnNode;
import org.modelmapper.internal.util.Members;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.spi.NameableType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitMappingVisitor
extends ClassVisitor {
    private static final String SOURCE_FIELD = "source";
    private static final String DEST_FIELD = "destination";
    private static final String PROXY_FIELD_DESC = "Ljava/lang/Object;";
    private static final String CONFIGURE_METHOD = "configure";
    private static final String CONFIGURE_METHOD_DESC = "()V";
    private static final String MAP_METHOD = "map";
    private static final String SKIP_METHOD = "skip";
    private static final String MAP_EXPR_OWNER_PREFIX = "org/modelmapper/builder";
    private static final String MAP_DEST_METHOD_DESC = "()Ljava/lang/Object;";
    private static final String MAP_SOURCE_METHOD_DESC = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String SKIP_DEST_METHOD_DESC = "(Ljava/lang/Object;)V";
    private static final String MAP_BOTH_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;)V";
    private static final String MUTATOR_METHOD_DESC_PATTERN = "(.+)V";
    private final Errors errors;
    private final InheritingConfiguration config;
    private final String propMapClassInternalName;
    private final String destClassInternalName;
    private final ClassLoader propertyMapClassLoader;
    private final Set<String> syntheticFields = new HashSet<String>();
    final List<VisitedMapping> mappings = new ArrayList<VisitedMapping>();

    public ExplicitMappingVisitor(Errors errors, InheritingConfiguration config, String propertyMapClassName, String destinationClassName, ClassLoader propertyMapClassLoader) {
        super(327680);
        this.errors = errors;
        this.config = config;
        this.propMapClassInternalName = propertyMapClassName.replace('.', '/');
        this.destClassInternalName = destinationClassName.replace('.', '/');
        this.propertyMapClassLoader = propertyMapClassLoader;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1000) == 4096) {
            this.syntheticFields.add(name);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals(CONFIGURE_METHOD) && desc.equals(CONFIGURE_METHOD_DESC)) {
            return new MappingCapturingVisitor();
        }
        return null;
    }

    private Field fieldFor(Class<?> type, FieldInsnNode fn) {
        return Members.fieldFor(type, fn.name);
    }

    private Method methodFor(Class<?> type, Type methodType, MethodInsnNode mn) {
        Type[] argumentTypes = methodType.getArgumentTypes();
        Class[] paramTypes = new Class[argumentTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = Primitives.primitiveFor(argumentTypes[i]);
            paramTypes[i] = paramType == null ? this.classFor(argumentTypes[i].getClassName()) : paramType;
        }
        return Members.methodFor(type, mn.name, paramTypes);
    }

    private Class<?> classFor(String className) {
        try {
            return Class.forName(className, true, this.propertyMapClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw this.errors.errorResolvingClass(e, className).toException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappingCapturingVisitor
    extends MethodVisitor {
        private final List<AbstractInsnNode> instructions;
        private VisitedMapping mapping;
        private int subjectType;
        private int mapType;

        private MappingCapturingVisitor() {
            super(327680);
            this.instructions = new ArrayList<AbstractInsnNode>();
            this.mapping = new VisitedMapping();
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.instructions.add(new InsnNode(opcode));
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            MethodInsnNode mn;
            AbstractInsnNode previous;
            if (opcode == 25 && !this.instructions.isEmpty() && this.isMethodInvocation(previous = this.instructions.get(this.instructions.size() - 1)) && (this.isMapBothMethod(mn = (MethodInsnNode)previous) || this.isMutator(mn))) {
                this.instructions.add(new InsnNode(opcode));
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!(opcode != 180 || owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) && ExplicitMappingVisitor.this.syntheticFields.contains(name))) {
                this.instructions.add(new FieldInsnNode(opcode, owner, name, desc));
            }
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            boolean isSourceMethod;
            boolean bl = isSourceMethod = owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) && (name.equals(ExplicitMappingVisitor.SOURCE_FIELD) || name.equals(ExplicitMappingVisitor.DEST_FIELD));
            if (opcode != 183 && !isSourceMethod && !Primitives.isPrimitiveWrapperInternalName(owner)) {
                this.instructions.add(new MethodInsnNode(opcode, owner, name, desc, itf));
            }
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.instructions.add(new InvokeDynamicInsnNode(name, desc, bsm, bsmArgs));
        }

        @Override
        public void visitEnd() {
            for (int i = 0; i < this.instructions.size(); ++i) {
                Class ownerType;
                AbstractInsnNode ins = this.instructions.get(i);
                if (ins.getOpcode() == 180) {
                    FieldInsnNode fn = (FieldInsnNode)ins;
                    if (fn.owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) && fn.desc.equals(ExplicitMappingVisitor.PROXY_FIELD_DESC)) {
                        if (fn.name.equals(ExplicitMappingVisitor.SOURCE_FIELD)) {
                            this.subjectType = 1;
                            continue;
                        }
                        if (!fn.name.equals(ExplicitMappingVisitor.DEST_FIELD)) continue;
                        this.subjectType = 2;
                        continue;
                    }
                    ownerType = ExplicitMappingVisitor.this.classFor(fn.owner.replace('/', '.'));
                    if (this.subjectType == 1) {
                        this.recordSourceField(ownerType, ExplicitMappingVisitor.this.fieldFor(ownerType, fn));
                        continue;
                    }
                    if (this.subjectType != 2) continue;
                    this.recordDestinationField(ownerType, ExplicitMappingVisitor.this.fieldFor(ownerType, fn));
                    continue;
                }
                if (this.isMethodInvocation(ins)) {
                    MethodInsnNode mn = (MethodInsnNode)ins;
                    if (this.isMapMethod(mn) || this.isSkipMethod(mn)) {
                        if (ExplicitMappingVisitor.MAP_DEST_METHOD_DESC.equals(mn.desc)) {
                            this.mapType = 1;
                            this.subjectType = 2;
                            continue;
                        }
                        if (ExplicitMappingVisitor.MAP_SOURCE_METHOD_DESC.equals(mn.desc)) {
                            if (this.subjectType == 2) {
                                this.recordProperties();
                                continue;
                            }
                            this.mapType = 2;
                            this.subjectType = 2;
                            continue;
                        }
                        if (ExplicitMappingVisitor.MAP_BOTH_METHOD_DESC.equals(mn.desc)) {
                            this.recordProperties();
                            continue;
                        }
                        if (!ExplicitMappingVisitor.SKIP_DEST_METHOD_DESC.equals(mn.desc)) continue;
                        this.mapType = 3;
                        continue;
                    }
                    if (this.subjectType == 0) continue;
                    ownerType = ExplicitMappingVisitor.this.classFor(mn.owner.replace('/', '.'));
                    Type methodType = Type.getMethodType(mn.desc);
                    if (this.mapType != 0 && this.isMutator(mn)) {
                        this.recordDestinationMethod(ownerType, ExplicitMappingVisitor.this.methodFor(ownerType, methodType, mn));
                        this.recordProperties();
                        continue;
                    }
                    if (this.subjectType == 1) {
                        this.recordSourceMethod(ownerType, ExplicitMappingVisitor.this.methodFor(ownerType, methodType, mn));
                        continue;
                    }
                    if (this.subjectType != 2) continue;
                    this.recordDestinationMethod(ownerType, ExplicitMappingVisitor.this.methodFor(ownerType, methodType, mn));
                    continue;
                }
                if (ins.getOpcode() != 25 && ins.getOpcode() != 177) continue;
                if (this.mapType == 3 && this.subjectType != 0) {
                    this.recordProperties();
                    continue;
                }
                if (this.mapType == 0) continue;
                ExplicitMappingVisitor.this.errors.missingDestination();
            }
        }

        private boolean isMethodInvocation(AbstractInsnNode ins) {
            return ins.getOpcode() == 182 || ins.getOpcode() == 185;
        }

        private boolean isMapMethod(MethodInsnNode mn) {
            return mn.name.equals(ExplicitMappingVisitor.MAP_METHOD) && (mn.owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) || mn.owner.startsWith(ExplicitMappingVisitor.MAP_EXPR_OWNER_PREFIX));
        }

        private boolean isSkipMethod(MethodInsnNode mn) {
            return mn.name.equals(ExplicitMappingVisitor.SKIP_METHOD) && (mn.owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) || mn.owner.startsWith(ExplicitMappingVisitor.MAP_EXPR_OWNER_PREFIX));
        }

        private boolean isMapBothMethod(MethodInsnNode mn) {
            return mn.name.equals(ExplicitMappingVisitor.MAP_METHOD) && (mn.owner.equals(ExplicitMappingVisitor.this.propMapClassInternalName) || mn.owner.startsWith(ExplicitMappingVisitor.MAP_EXPR_OWNER_PREFIX)) && mn.desc.equals(ExplicitMappingVisitor.MAP_BOTH_METHOD_DESC);
        }

        private boolean isMutator(MethodInsnNode mn) {
            return Pattern.matches(ExplicitMappingVisitor.MUTATOR_METHOD_DESC_PATTERN, mn.desc);
        }

        private void recordProperties() {
            ExplicitMappingVisitor.this.mappings.add(this.mapping);
            this.mapping = new VisitedMapping();
            this.subjectType = 0;
            this.mapType = 0;
        }

        private void recordSourceMethod(Class<?> type, Method method) {
            this.assertNotFinal(method);
            if (PropertyInfoResolver.ACCESSORS.isValid(method)) {
                String propertyName = ExplicitMappingVisitor.this.config.getSourceNameTransformer().transform(method.getName(), NameableType.METHOD);
                this.mapping.sourceAccessors.add(PropertyInfoRegistry.accessorFor(type, method, ExplicitMappingVisitor.this.config, propertyName));
            } else {
                ExplicitMappingVisitor.this.errors.invalidSourceMethod(method);
            }
        }

        private void recordSourceField(Class<?> type, Field field) {
            this.assertNotFinal(field);
            if (PropertyInfoResolver.FIELDS.isValid(field)) {
                String propertyName = ExplicitMappingVisitor.this.config.getSourceNameTransformer().transform(field.getName(), NameableType.FIELD);
                this.mapping.sourceAccessors.add(PropertyInfoRegistry.fieldPropertyFor(type, field, ExplicitMappingVisitor.this.config, propertyName));
            } else {
                ExplicitMappingVisitor.this.errors.invalidSourceField(field);
            }
        }

        private void recordDestinationMethod(Class<?> type, Method method) {
            this.assertNotFinal(method);
            if (PropertyInfoResolver.MUTATORS.isValid(method)) {
                String propertyName = ExplicitMappingVisitor.this.config.getDestinationNameTransformer().transform(method.getName(), NameableType.METHOD);
                this.mapping.destinationMutators.add(PropertyInfoRegistry.mutatorFor(type, method, ExplicitMappingVisitor.this.config, propertyName));
            } else if (PropertyInfoResolver.ACCESSORS.isValid(method)) {
                String propertyName = ExplicitMappingVisitor.this.config.getSourceNameTransformer().transform(method.getName(), NameableType.METHOD);
                this.mapping.destinationAccessors.add(PropertyInfoRegistry.accessorFor(type, method, ExplicitMappingVisitor.this.config, propertyName));
                Mutator mutator = TypeInfoRegistry.typeInfoFor(type, ExplicitMappingVisitor.this.config).mutatorForAccessorMethod(method.getName());
                if (mutator != null) {
                    this.mapping.destinationMutators.add(mutator);
                } else {
                    ExplicitMappingVisitor.this.errors.missingMutatorForAccessor(method);
                }
            } else {
                ExplicitMappingVisitor.this.errors.invalidDestinationMethod(method);
            }
        }

        private void recordDestinationField(Class<?> type, Field field) {
            this.assertNotFinal(field);
            if (PropertyInfoResolver.FIELDS.isValid(field)) {
                String propertyName = ExplicitMappingVisitor.this.config.getDestinationNameTransformer().transform(field.getName(), NameableType.FIELD);
                PropertyInfoImpl.FieldPropertyInfo propertyInfo = PropertyInfoRegistry.fieldPropertyFor(type, field, ExplicitMappingVisitor.this.config, propertyName);
                this.mapping.destinationAccessors.add(propertyInfo);
                this.mapping.destinationMutators.add(propertyInfo);
            } else {
                ExplicitMappingVisitor.this.errors.invalidDestinationField(field);
            }
        }

        private void assertNotFinal(Member member) {
            if (Modifier.isFinal(member.getDeclaringClass().getModifiers())) {
                ExplicitMappingVisitor.this.errors.invocationAgainstFinalClass(member.getDeclaringClass());
            }
            if (member instanceof Method && Modifier.isFinal(member.getModifiers())) {
                ExplicitMappingVisitor.this.errors.invocationAgainstFinalMethod(member);
            }
        }
    }

    static class VisitedMapping {
        List<Accessor> sourceAccessors = new ArrayList<Accessor>();
        List<Accessor> destinationAccessors = new ArrayList<Accessor>();
        List<Mutator> destinationMutators = new ArrayList<Mutator>();

        VisitedMapping() {
        }
    }
}

