/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.List;
import org.modelmapper.convention.InexactMatcher;
import org.modelmapper.spi.MatchingStrategy;

final class LooseMatchingStrategy
implements MatchingStrategy {
    LooseMatchingStrategy() {
    }

    public boolean matches(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
        return new Matcher(propertyNameInfo).match();
    }

    public boolean isExact() {
        return false;
    }

    public String toString() {
        return "Loose";
    }

    static class Matcher
    extends InexactMatcher {
        boolean lastSourceMatched;
        boolean lastDestinationMatched;

        Matcher(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
            super(propertyNameInfo);
        }

        boolean match() {
            List<String[]> destTokens = this.propertyNameInfo.getDestinationPropertyTokens();
            for (int destIndex = destTokens.size() - 1; destIndex >= 0 && !this.lastSourceMatched; --destIndex) {
                String[] tokens = destTokens.get(destIndex);
                for (int destTokenIndex = 0; destTokenIndex < tokens.length; ++destTokenIndex) {
                    int matchedTokens = this.matchSourcePropertyName(tokens, destTokenIndex);
                    if (destIndex == destTokens.size() - 1 && (matchedTokens > 0 || this.matchSourcePropertyType(tokens[destTokenIndex]) || this.matchSourceClass(tokens[destTokenIndex]))) {
                        this.lastDestinationMatched = true;
                    }
                    if (matchedTokens <= 1) continue;
                    destTokenIndex += matchedTokens - 1;
                }
            }
            return this.lastSourceMatched && this.lastDestinationMatched;
        }

        int matchSourcePropertyName(String[] destTokens, int destStartIndex) {
            for (int sourceIndex = this.sourceTokens.size() - 1; sourceIndex >= 0; --sourceIndex) {
                String[] srcTokens = (String[])this.sourceTokens.get(sourceIndex);
                int matched = Matcher.matchTokens(srcTokens, destTokens, destStartIndex);
                if (matched <= 0) continue;
                if (sourceIndex == this.sourceTokens.size() - 1) {
                    this.lastSourceMatched = true;
                }
                return matched;
            }
            return 0;
        }
    }
}

