/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.structure.type.BigIntType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.TimeType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class InformixTypeConverter
extends AbstractTypeConverter {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^(int(eger)?)$", 2);
    private static final Pattern INTEGER8_PATTERN = Pattern.compile("^(int(eger)?8)$", 2);
    private static final Pattern SERIAL_PATTERN = Pattern.compile("^(serial)(\\s*\\(\\d+\\)|)$", 2);
    private static final Pattern SERIAL8_PATTERN = Pattern.compile("^(serial8)(\\s*\\(\\d+\\)|)$", 2);
    private static final String INTERVAL_FIELD_QUALIFIER = "HOUR TO FRACTION(5)";
    private static final String DATETIME_FIELD_QUALIFIER = "YEAR TO FRACTION(5)";

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof InformixDatabase;
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        DataType type = super.getDataType(columnTypeString, autoIncrement);
        if (autoIncrement != null && autoIncrement.booleanValue()) {
            if (this.isSerial(type)) {
                return new CustomType("SERIAL", 0, 0);
            }
            if (this.isSerial8(type)) {
                return new CustomType("SERIAL8", 0, 0);
            }
            throw new IllegalArgumentException("Unknown autoincrement type: " + columnTypeString);
        }
        return type;
    }

    private boolean isSerial(DataType type) {
        return INTEGER_PATTERN.matcher(type.getDataTypeName()).matches() || SERIAL_PATTERN.matcher(type.getDataTypeName()).matches();
    }

    private boolean isSerial8(DataType type) {
        return INTEGER8_PATTERN.matcher(type.getDataTypeName()).matches() || SERIAL8_PATTERN.matcher(type.getDataTypeName()).matches() || "BIGINT".equalsIgnoreCase(type.getDataTypeName());
    }

    public BooleanType getBooleanType() {
        return new BooleanType(){

            public String getTrueBooleanValue() {
                return "'t'";
            }

            public String getFalseBooleanValue() {
                return "'f'";
            }
        };
    }

    public BigIntType getBigIntType() {
        return new BigIntType("INT8");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("MONEY");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("DATETIME YEAR TO FRACTION(5)");
    }

    public TimeType getTimeType() {
        return new TimeType("INTERVAL HOUR TO FRACTION(5)");
    }
}

