/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.lang.reflect.Method;
import java.sql.Driver;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;

public class DerbyDatabase
extends AbstractDatabase {
    private Logger log = LogFactory.getLogger();
    protected int driverVersionMajor;
    protected int driverVersionMinor;

    public DerbyDatabase() {
        this.determineDriverVersion();
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "Apache Derby".equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:derby")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }

    public String getTypeName() {
        return "derby";
    }

    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    public boolean supportsSequences() {
        return this.driverVersionMajor == 10 && this.driverVersionMinor >= 6 || this.driverVersionMajor >= 11;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "CURRENT_TIMESTAMP";
    }

    public String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate)) {
            return "DATE(" + super.getDateLiteral(isoDate) + ")";
        }
        if (this.isTimeOnly(isoDate)) {
            return "TIME(" + super.getDateLiteral(isoDate) + ")";
        }
        String dateString = super.getDateLiteral(isoDate);
        int decimalDigits = dateString.length() - dateString.indexOf(46) - 2;
        String padding = "";
        for (int i = 6; i > decimalDigits; --i) {
            padding = padding + "0";
        }
        return "TIMESTAMP(" + dateString.replaceFirst("'$", padding + "'") + ")";
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public String getViewDefinition(String schemaName, String name) throws DatabaseException {
        return super.getViewDefinition(schemaName, name).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    public void close() throws DatabaseException {
        String url = this.getConnection().getURL();
        String driverName = this.getDefaultDriver(url);
        super.close();
        if (driverName.toLowerCase().contains("embedded")) {
            try {
                url = url.contains(";") ? url.substring(0, url.indexOf(";")) + ";shutdown=true" : url + ";shutdown=true";
                LogFactory.getLogger().info("Shutting down derby connection: " + url);
                ((Driver)Class.forName(driverName).newInstance()).connect(url, null);
            }
            catch (Exception e) {
                LogFactory.getLogger().severe("Error closing derby cleanly", e);
            }
        }
    }

    protected void determineDriverVersion() {
        try {
            this.getClass();
            Class<?> sysinfoClass = Class.forName("org.apache.derby.tools.sysinfo");
            Method majorVersionGetter = sysinfoClass.getMethod("getMajorVersion", new Class[0]);
            Method minorVersionGetter = sysinfoClass.getMethod("getMinorVersion", new Class[0]);
            this.driverVersionMajor = (Integer)majorVersionGetter.invoke(null, new Object[0]);
            this.driverVersionMinor = (Integer)minorVersionGetter.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.log.debug("Unable to load/access Apache Derby driver class org.apache.derby.tools.sysinfo to check version: " + e.getMessage());
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }
}

