/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.TextNode;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    @TextNode(nodeName="where")
    private String whereClause;

    public UpdateDataChange() {
        super("update", "Update Data", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        UpdateStatement statement = new UpdateStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.columns) {
            statement.addNewColumnValue(column.getName(), column.getValueObject());
        }
        statement.setWhereClause(this.whereClause);
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Data updated in " + this.getTableName();
    }
}

