/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeProperty;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.FindForeignKeyConstraintsStatement;

public class DropAllForeignKeyConstraintsChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    @ChangeProperty(includeInSerialization=false)
    private List<DropForeignKeyConstraintChange> childDropChanges;

    public DropAllForeignKeyConstraintsChange() {
        super("dropAllForeignKeyConstraints", "Drop All Foreign Key Constraints", 1);
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        if (this.childDropChanges == null) {
            this.generateChildren(database);
        }
        if (this.childDropChanges != null) {
            for (DropForeignKeyConstraintChange change : this.childDropChanges) {
                sqlStatements.addAll(Arrays.asList(change.generateStatements(database)));
            }
        }
        return sqlStatements.toArray(new SqlStatement[sqlStatements.size()]);
    }

    public String getConfirmationMessage() {
        return "Foreign keys on base table " + this.getBaseTableName() + " dropped";
    }

    private void generateChildren(Database database) {
        this.childDropChanges = new ArrayList<DropForeignKeyConstraintChange>();
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        FindForeignKeyConstraintsStatement sql = new FindForeignKeyConstraintsStatement(this.getBaseTableSchemaName(), this.getBaseTableName());
        try {
            List<Map> results = executor.queryForList(sql);
            if (results != null && results.size() > 0) {
                for (Map result : results) {
                    String baseTableName = (String)result.get("TABLE_NAME");
                    String constraintName = (String)result.get("CONSTRAINT_NAME");
                    if (this.getBaseTableName().equalsIgnoreCase(baseTableName)) {
                        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
                        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getBaseTableSchemaName());
                        dropForeignKeyConstraintChange.setBaseTableName(baseTableName);
                        dropForeignKeyConstraintChange.setConstraintName(constraintName);
                        this.childDropChanges.add(dropForeignKeyConstraintChange);
                        continue;
                    }
                    throw new IllegalStateException("Expected to return only foreign keys for base table name: " + this.getBaseTableName() + " and got results for table: " + baseTableName);
                }
            }
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException("Failed to find foreign keys for table: " + this.getBaseTableName(), e);
        }
    }

    public boolean requiresUpdatedDatabaseMetadata(Database database) {
        return true;
    }
}

