/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.beans.Introspector;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.DataWriter;

final class XMLDataWriter
implements DataWriter {
    private String name;
    private final Stack<String> objectNames = new Stack();
    private final Stack<Boolean> arrayState = new Stack();
    private final Writer out;
    public boolean isArray;

    XMLDataWriter(Object bean, Writer out) throws IOException {
        this.name = Introspector.decapitalize(bean.getClass().getSimpleName());
        this.out = out;
    }

    XMLDataWriter(Object bean, StaplerResponse rsp) throws IOException {
        this(bean, rsp.getWriter());
    }

    public void name(String name) {
        this.name = name;
    }

    public void valuePrimitive(Object v) throws IOException {
        this.value(v.toString());
    }

    public void value(String v) throws IOException {
        String n = this.adjustName();
        this.out.write('<' + n + '>');
        this.out.write(this.escape(v));
        this.out.write("</" + n + '>');
    }

    private String escape(String v) {
        StringBuffer buf = new StringBuffer(v.length() + 64);
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public void valueNull() {
    }

    public void startArray() {
        this.isArray = true;
    }

    public void endArray() {
        this.isArray = false;
    }

    public void startObject() throws IOException {
        this.objectNames.push(this.name);
        this.out.write('<' + this.adjustName() + '>');
        this.arrayState.push(this.isArray);
        this.isArray = false;
    }

    public void endObject() throws IOException {
        this.name = this.objectNames.pop();
        this.isArray = this.arrayState.pop();
        this.out.write("</" + this.adjustName() + '>');
    }

    private String adjustName() {
        if (this.isArray) {
            return XMLDataWriter.toSingular(this.name);
        }
        return this.name;
    }

    static String toSingular(String name) {
        if (name.endsWith("s")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

