/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.export.CustomExportedBean;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NotExportableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Property
implements Comparable<Property> {
    public final String name;
    final ModelBuilder owner;
    public final int visibility;
    public final Model parent;
    private final boolean inline;
    static final Set<Class> STRING_TYPES = new HashSet<Class>(Arrays.asList(String.class, URL.class));
    static final Set<Class> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class, Short.class, Character.class, Float.class, Double.class));

    Property(Model parent, String name, Exported exported) {
        this.parent = parent;
        this.owner = parent.parent;
        this.name = exported.name().length() > 1 ? exported.name() : name;
        int v = exported.visibility();
        if (v == 0) {
            v = parent.defaultVisibility;
        }
        this.visibility = v;
        this.inline = exported.inline();
    }

    @Override
    public int compareTo(Property that) {
        return this.name.compareTo(that.name);
    }

    public abstract Type getGenericType();

    public abstract Class getType();

    public abstract String getJavadoc();

    public void writeTo(Object object, int depth, DataWriter writer) throws IOException {
        if (this.visibility < depth) {
            return;
        }
        try {
            writer.name(this.name);
            this.writeValue(this.getValue(object), depth - (this.inline ? 1 : 0), writer);
        }
        catch (IllegalAccessException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
    }

    private void writeValue(Object value, int depth, DataWriter writer) throws IOException {
        this.writeValue(value, depth, writer, false);
    }

    private void writeValue(Object value, int depth, DataWriter writer, boolean skipIfFail) throws IOException {
        Model<?> model;
        block16: {
            if (value == null) {
                writer.valueNull();
                return;
            }
            if (value instanceof CustomExportedBean) {
                this.writeValue(((CustomExportedBean)value).toExportedObject(), depth, writer);
                return;
            }
            Class<?> c = value.getClass();
            if (STRING_TYPES.contains(c)) {
                writer.value(value.toString());
                return;
            }
            if (PRIMITIVE_TYPES.contains(c)) {
                writer.valuePrimitive(value);
                return;
            }
            if (c.getComponentType() != null) {
                writer.startArray();
                for (Object item : (Object[])value) {
                    this.writeValue(item, depth, writer, true);
                }
                writer.endArray();
                return;
            }
            if (value instanceof Collection) {
                writer.startArray();
                for (Object item : (Collection)value) {
                    this.writeValue(item, depth, writer, true);
                }
                writer.endArray();
                return;
            }
            if (value instanceof Map) {
                writer.startObject();
                for (Map.Entry e : ((Map)value).entrySet()) {
                    writer.name(e.getKey().toString());
                    this.writeValue(e.getValue(), depth, writer);
                }
                writer.endObject();
                return;
            }
            if (value instanceof Date) {
                writer.valuePrimitive(((Date)value).getTime());
                return;
            }
            if (value instanceof Calendar) {
                writer.valuePrimitive(((Calendar)value).getTimeInMillis());
                return;
            }
            if (value instanceof Enum) {
                writer.value(value.toString());
                return;
            }
            writer.startObject();
            model = null;
            try {
                model = this.owner.get(c);
            }
            catch (NotExportableException e) {
                if (skipIfFail) break block16;
                throw e;
            }
        }
        if (model != null) {
            model.writeNestedObjectTo(value, depth + 1, writer);
        }
        writer.endObject();
    }

    protected abstract Object getValue(Object var1) throws IllegalAccessException, InvocationTargetException;
}

