/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.DataWriter;

class JSONDataWriter
implements DataWriter {
    private boolean needComma;
    private final Writer out;

    JSONDataWriter(Writer out) throws IOException {
        this.out = out;
    }

    JSONDataWriter(StaplerResponse rsp) throws IOException {
        this.out = rsp.getWriter();
    }

    public void name(String name) throws IOException {
        this.comma();
        this.out.write('\"' + name + "\":");
        this.needComma = false;
    }

    protected void data(String v) throws IOException {
        this.comma();
        this.out.write(v);
    }

    private void comma() throws IOException {
        if (this.needComma) {
            this.out.write(44);
        }
        this.needComma = true;
    }

    public void valuePrimitive(Object v) throws IOException {
        this.data(v.toString());
    }

    public void value(String v) throws IOException {
        StringBuilder buf = new StringBuilder(v.length());
        buf.append('\"');
        block7: for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
        this.data(buf.toString());
    }

    public void valueNull() throws IOException {
        this.data("null");
    }

    public void startArray() throws IOException {
        this.comma();
        this.out.write(91);
        this.needComma = false;
    }

    public void endArray() throws IOException {
        this.out.write(93);
        this.needComma = true;
    }

    public void startObject() throws IOException {
        this.comma();
        this.out.write(123);
        this.needComma = false;
    }

    public void endObject() throws IOException {
        this.out.write(125);
        this.needComma = true;
    }
}

