/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.stapler.AncestorImpl;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.WebApp;

public class Stapler
extends HttpServlet {
    private ServletContext context;
    private WebApp webApp;
    static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private static ThreadLocal<RequestImpl> CURRENT_REQUEST = new ThreadLocal();
    private static ThreadLocal<ResponseImpl> CURRENT_RESPONSE = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Stapler.class.getName());
    private static final Set<String> TEXT_FILES = new HashSet<String>(Arrays.asList("css", "js", "html", "txt", "java", "htm", "c", "cpp", "h", "rb", "pl", "py", "xml"));
    public static final ConvertUtilsBean CONVERT_UTILS = new ConvertUtilsBean();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        this.webApp = WebApp.get(this.context);
        String defaultEncodings = servletConfig.getInitParameter("default-encodings");
        if (defaultEncodings != null) {
            for (String t : defaultEncodings.split(";")) {
                int idx = (t = t.trim()).indexOf(61);
                if (idx < 0) {
                    throw new ServletException("Invalid format: " + t);
                }
                this.webApp.defaultEncodingForStaticResources.put(t.substring(0, idx), t.substring(idx + 1));
            }
        }
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    protected void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        Object root;
        OpenConnection con;
        String servletPath = this.getServletPath(req);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Processing request for " + servletPath);
        }
        boolean staticLink = false;
        if (servletPath.startsWith("/static/")) {
            int idx = servletPath.indexOf(47, 8);
            servletPath = servletPath.substring(idx);
            staticLink = true;
        }
        if (servletPath.length() != 0 && (con = this.openResourcePathByLocale(req, servletPath)) != null) {
            long expires;
            long l = expires = MetaClass.NO_CACHE ? 0L : 86400000L;
            if (staticLink) {
                expires *= 365L;
            }
            if (this.serveStaticResource(req, (StaplerResponse)new ResponseImpl(this, rsp), con, expires)) {
                return;
            }
        }
        if ((root = this.context.getAttribute("app")) == null) {
            throw new ServletException("there's no \"app\" attribute in the application context.");
        }
        this.invoke(req, rsp, root, servletPath);
    }

    private OpenConnection openResourcePathByLocale(HttpServletRequest req, String resourcePath) throws IOException {
        URL url = this.getServletContext().getResource(resourcePath);
        if (url == null) {
            return null;
        }
        return this.selectResourceByLocale(url, req.getLocale());
    }

    OpenConnection selectResourceByLocale(URL url, Locale locale) throws IOException {
        String s = url.toString();
        int idx = s.lastIndexOf(46);
        if (idx < 0) {
            return this.openURL(url);
        }
        String base = s.substring(0, idx);
        String ext = s.substring(idx);
        if (ext.indexOf(47) >= 0) {
            return this.openURL(url);
        }
        OpenConnection con = this.openURL(new URL(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant() + ext));
        if (con != null) {
            return con;
        }
        con = this.openURL(new URL(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + ext));
        if (con != null) {
            return con;
        }
        con = this.openURL(new URL(base + '_' + locale.getLanguage() + ext));
        if (con != null) {
            return con;
        }
        return this.openURL(url);
    }

    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, OpenConnection con, long expiration) throws IOException {
        if (con == null) {
            return false;
        }
        return this.serveStaticResource(req, rsp, con.stream, con.connection.getLastModified(), expiration, con.connection.getContentLength(), con.connection.getURL().toString());
    }

    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, URL url, long expiration) throws IOException {
        return this.serveStaticResource(req, rsp, this.openURL(url), expiration);
    }

    private OpenConnection openURL(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        File f = this.toFile(url);
        if (f != null && f.isDirectory()) {
            return null;
        }
        URLConnection con = url.openConnection();
        try {
            return new OpenConnection(con);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, InputStream in, long lastModified, long expiration, int contentLength, String fileName) throws IOException {
        try {
            int len;
            OutputStream out;
            if (lastModified != 0L) {
                String since = req.getHeader("If-Modified-Since");
                SimpleDateFormat format = HTTP_DATE_FORMAT.get();
                if (since != null) {
                    try {
                        long ims = format.parse(since).getTime();
                        if (lastModified < ims + 1000L) {
                            rsp.setStatus(304);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (ParseException e) {
                    }
                    catch (NumberFormatException e) {
                        this.getServletContext().log("Error parsing [" + since + "]", (Throwable)e);
                        throw e;
                    }
                }
                String lastModifiedStr = format.format(new Date(lastModified));
                rsp.setHeader("Last-Modified", lastModifiedStr);
                if (expiration <= 0L) {
                    rsp.setHeader("Expires", lastModifiedStr);
                } else {
                    rsp.setHeader("Expires", format.format(new Date(new Date().getTime() + expiration)));
                }
            }
            int idx = fileName.lastIndexOf(47);
            fileName = fileName.substring(idx + 1);
            idx = fileName.lastIndexOf(92);
            fileName = fileName.substring(idx + 1);
            String mimeType = this.getServletContext().getMimeType(fileName);
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            if (this.webApp.defaultEncodingForStaticResources.containsKey(mimeType)) {
                mimeType = mimeType + ";charset=" + this.webApp.defaultEncodingForStaticResources.get(mimeType);
            }
            rsp.setContentType(mimeType);
            idx = fileName.lastIndexOf(46);
            String ext = fileName.substring(idx + 1);
            if (mimeType.startsWith("text/") || TEXT_FILES.contains(ext)) {
                out = rsp.getCompressedOutputStream(req);
            } else {
                if (contentLength != -1) {
                    rsp.setContentLength(contentLength);
                }
                out = rsp.getOutputStream();
            }
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            boolean bl = true;
            return bl;
        }
        finally {
            in.close();
        }
    }

    private File toFile(URL url) {
        String urlstr = url.toExternalForm();
        if (!urlstr.startsWith("file:")) {
            return null;
        }
        try {
            return new File(url.toURI().getPath());
        }
        catch (URISyntaxException e) {
            try {
                return new File(new URI(null, urlstr, null).getPath());
            }
            catch (URISyntaxException _) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpServletRequest req, HttpServletResponse rsp, Object root, String url) throws IOException, ServletException {
        RequestImpl sreq = new RequestImpl(this, req, new ArrayList<AncestorImpl>(), new TokenList(url));
        RequestImpl oreq = CURRENT_REQUEST.get();
        CURRENT_REQUEST.set(sreq);
        ResponseImpl srsp = new ResponseImpl(this, rsp);
        ResponseImpl orsp = CURRENT_RESPONSE.get();
        CURRENT_RESPONSE.set(srsp);
        try {
            this.invoke(sreq, srsp, root);
        }
        finally {
            CURRENT_REQUEST.set(oreq);
            CURRENT_RESPONSE.set(orsp);
        }
    }

    void invoke(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        if (Dispatcher.traceable()) {
            Dispatcher.traceEval(req, rsp, node);
        }
        if (node instanceof StaplerProxy) {
            Object n;
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerProxy)", ").getTarget()");
            }
            if ((n = ((StaplerProxy)node).getTarget()) != node && n != null) {
                this.invoke(req, rsp, n);
                return;
            }
        }
        AncestorImpl a = new AncestorImpl(req.ancestors);
        a.set(node, req);
        if (node == null) {
            if (!Dispatcher.TRACE) {
                rsp.sendError(404);
            } else {
                rsp.setStatus(404);
                rsp.setContentType("text/html;charset=UTF-8");
                PrintWriter w = rsp.getWriter();
                w.println("<html><body>");
                w.println("<h1>404 Not Found</h1>");
                w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
                w.println("<pre>");
                EvaluationTrace.get(req).printHtml(w);
                w.println("<font color=red>-&gt; unexpected null!</font>");
                w.println("</pre>");
                w.println("<p>If this 404 is unexpected, double check the last part of the trace to see if it should have evaluated to null.");
                w.println("</body></html>");
            }
            return;
        }
        MetaClass metaClass = this.webApp.getMetaClass(node.getClass());
        if (!req.tokens.hasMore()) {
            String servletPath = this.getServletPath(req);
            if (!servletPath.endsWith("/")) {
                String target = req.getContextPath() + servletPath + '/';
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Redirecting to " + target);
                }
                rsp.sendRedirect2(target);
                return;
            }
            if (req.getMethod().equals("DELETE") && node instanceof HttpDeletable) {
                ((HttpDeletable)node).delete(req, rsp);
                return;
            }
            for (Facet f : this.webApp.facets) {
                if (!f.handleIndexRequest(req, rsp, node, metaClass)) continue;
                return;
            }
            URL indexHtml = this.getSideFileURL(node, "index.html");
            if (indexHtml != null && this.serveStaticResource((HttpServletRequest)req, (StaplerResponse)rsp, indexHtml, 0L)) {
                return;
            }
        }
        try {
            for (Dispatcher d : metaClass.dispatchers) {
                if (!d.dispatch(req, rsp, node)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Handled by " + d);
                }
                return;
            }
        }
        catch (IllegalAccessException e) {
            this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
            throw new ServletException(e.getTargetException());
        }
        if (node instanceof StaplerFallback) {
            Object n;
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerFallback)", ").getStaplerFallback()");
            }
            if ((n = ((StaplerFallback)node).getStaplerFallback()) != node && n != null) {
                this.invoke(req, rsp, n);
                return;
            }
        }
        if (!Dispatcher.TRACE) {
            rsp.sendError(404);
        } else {
            rsp.setStatus(404);
            rsp.setContentType("text/html;charset=UTF-8");
            PrintWriter w = rsp.getWriter();
            w.println("<html><body>");
            w.println("<h1>404 Not Found</h1>");
            w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
            w.println("<pre>");
            EvaluationTrace.get(req).printHtml(w);
            w.printf("<font color=red>-&gt; No matching rule was found on &lt;%s&gt; for \"%s\"</font>\n", node, req.tokens.assembleRestOfPath());
            w.println("</pre>");
            w.printf("<p>&lt;%s&gt; has the following URL mappings, in the order of preference:", node);
            w.println("<ol>");
            for (Dispatcher d : metaClass.dispatchers) {
                w.println("<li>");
                w.println(d.toString());
            }
            w.println("</ol>");
            w.println("</body></html>");
        }
    }

    public void forward(RequestDispatcher dispatcher, StaplerRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        dispatcher.forward((ServletRequest)req, (ServletResponse)new ResponseImpl(this, rsp));
    }

    private URL getSideFileURL(Object node, String fileName) throws MalformedURLException {
        for (Class<?> c = node.getClass(); c != Object.class; c = c.getSuperclass()) {
            String name = "/WEB-INF/side-files/" + c.getName().replace('.', '/') + '/' + fileName;
            URL url = this.getServletContext().getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static String getViewURL(Class clazz, String jspName) {
        return "/WEB-INF/side-files/" + clazz.getName().replace('.', '/') + '/' + jspName;
    }

    public static void setRoot(ServletContextEvent event, Object rootApp) {
        event.getServletContext().setAttribute("app", rootApp);
    }

    public static void setClassLoader(ServletContext context, ClassLoader classLoader) {
        WebApp.get(context).setClassLoader(classLoader);
    }

    public static ClassLoader getClassLoader(ServletContext context) {
        return WebApp.get(context).getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.webApp.getClassLoader();
    }

    public static StaplerRequest getCurrentRequest() {
        return CURRENT_REQUEST.get();
    }

    public static StaplerResponse getCurrentResponse() {
        return CURRENT_RESPONSE.get();
    }

    public static Stapler getCurrent() {
        return CURRENT_REQUEST.get().getStapler();
    }

    private String getServletPath(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            servletPath = servletPath + pathInfo;
        }
        return servletPath;
    }

    public static Converter lookupConverter(Class type) {
        Converter c = CONVERT_UTILS.lookup(type);
        if (c != null) {
            return c;
        }
        return ConvertUtils.lookup((Class)type);
    }

    static {
        CONVERT_UTILS.register(new Converter(){

            public Object convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
        }, URL.class);
        CONVERT_UTILS.register(new Converter(){

            public FileItem convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return Stapler.getCurrentRequest().getFileItem(value.toString());
                }
                catch (ServletException e) {
                    throw new ConversionException((Throwable)e);
                }
                catch (IOException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
        }, FileItem.class);
        CONVERT_UTILS.register((Converter)new IntegerConverter(null), Integer.class);
        CONVERT_UTILS.register((Converter)new FloatConverter(null), Float.class);
        CONVERT_UTILS.register((Converter)new DoubleConverter(null), Double.class);
    }

    private static final class OpenConnection {
        final URLConnection connection;
        final InputStream stream;

        private OpenConnection(URLConnection connection, InputStream stream) {
            this.connection = connection;
            this.stream = stream;
        }

        private OpenConnection(URLConnection connection) throws IOException {
            this(connection, connection.getInputStream());
        }
    }
}

