/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

public class ResponseImpl
extends HttpServletResponseWrapper
implements StaplerResponse {
    private final Stapler stapler;
    private final HttpServletResponse response;
    private static final ModelBuilder MODEL_BUILDER = new ModelBuilder();

    public ResponseImpl(Stapler stapler, HttpServletResponse response) {
        super(response);
        this.stapler = stapler;
        this.response = response;
    }

    public void forward(Object it, String url, StaplerRequest request) throws ServletException, IOException {
        this.stapler.invoke(request, this.response, it, url);
    }

    public void forwardToPreviousPage(StaplerRequest request) throws ServletException, IOException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            referer = ".";
        }
        this.sendRedirect(referer);
    }

    public void sendRedirect(String url) throws IOException {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("/")) {
            super.sendRedirect(url);
            return;
        }
        String base = Stapler.getCurrentRequest().getRequestURI();
        base = base.substring(0, base.lastIndexOf(47) + 1);
        if (!url.equals(".")) {
            base = base + url;
        }
        super.sendRedirect(url);
    }

    public void sendRedirect2(String url) throws IOException {
        this.sendRedirect(ResponseImpl.encode(url));
    }

    public void serveFile(StaplerRequest req, URL resource, long expiration) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource((HttpServletRequest)req, (StaplerResponse)this, resource, expiration)) {
            this.sendError(404);
        }
    }

    public void serveFile(StaplerRequest req, URL resource) throws ServletException, IOException {
        this.serveFile(req, resource, -1L);
    }

    public void serveLocalizedFile(StaplerRequest request, URL res) throws ServletException, IOException {
        this.serveLocalizedFile(request, res, -1L);
    }

    public void serveLocalizedFile(StaplerRequest request, URL res, long expiration) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource((HttpServletRequest)request, (StaplerResponse)this, this.stapler.selectResourceByLocale(res, request.getLocale()), expiration)) {
            this.sendError(404);
        }
    }

    public void serveFile(StaplerRequest req, InputStream data, long lastModified, long expiration, int contentLength, String fileName) throws ServletException, IOException {
        if (!this.stapler.serveStaticResource(req, this, data, lastModified, expiration, contentLength, fileName)) {
            this.sendError(404);
        }
    }

    public void serveFile(StaplerRequest req, InputStream data, long lastModified, int contentLength, String fileName) throws ServletException, IOException {
        this.serveFile(req, data, lastModified, -1L, contentLength, fileName);
    }

    public void serveExposedBean(StaplerRequest req, Object exposedBean, Flavor flavor) throws ServletException, IOException {
        String pad = null;
        PrintWriter w = null;
        this.setContentType(flavor.contentType);
        if (flavor == Flavor.JSON) {
            pad = req.getParameter("jsonp");
            w = this.getWriter();
            if (pad != null) {
                w.print(pad + '(');
            }
        }
        int depth = 0;
        try {
            String s = req.getParameter("depth");
            if (s != null) {
                depth = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            throw new ServletException("Depth parameter must be a number");
        }
        Model<?> p = MODEL_BUILDER.get(exposedBean.getClass());
        p.writeTo(exposedBean, depth, flavor.createDataWriter(exposedBean, this));
        if (pad != null) {
            w.print(')');
        }
    }

    public OutputStream getCompressedOutputStream(HttpServletRequest req) throws IOException {
        String acceptEncoding = req.getHeader("Accept-Encoding");
        if (acceptEncoding == null || acceptEncoding.indexOf("gzip") == -1) {
            return this.getOutputStream();
        }
        this.addHeader("Content-Encoding", "gzip");
        return new GZIPOutputStream((OutputStream)this.getOutputStream());
    }

    public Writer getCompressedWriter(HttpServletRequest req) throws IOException {
        String acceptEncoding = req.getHeader("Accept-Encoding");
        if (acceptEncoding == null || acceptEncoding.indexOf("gzip") == -1) {
            return this.getWriter();
        }
        this.addHeader("Content-Encoding", "gzip");
        return new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)this.getOutputStream()), this.getCharacterEncoding());
    }

    public int reverseProxyTo(URL url, StaplerRequest req) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        Enumeration h = req.getHeaderNames();
        while (h.hasMoreElements()) {
            String key = (String)h.nextElement();
            Enumeration v = req.getHeaders(key);
            while (v.hasMoreElements()) {
                con.addRequestProperty(key, (String)v.nextElement());
            }
        }
        con.setRequestMethod(req.getMethod());
        this.copyAndClose((InputStream)req.getInputStream(), con.getOutputStream());
        int code = con.getResponseCode();
        this.setStatus(code, con.getResponseMessage());
        Map<String, List<String>> rspHeaders = con.getHeaderFields();
        for (Map.Entry<String, List<String>> header : rspHeaders.entrySet()) {
            if (header.getKey() == null) continue;
            for (String value : header.getValue()) {
                this.addHeader(header.getKey(), value);
            }
        }
        this.copyAndClose(con.getInputStream(), (OutputStream)this.getOutputStream());
        return code;
    }

    private void copyAndClose(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static String encode(String s) {
        try {
            boolean escaped = false;
            StringBuffer out = new StringBuffer(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)buf, "UTF-8");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c < '\u0080' && c != ' ') {
                    out.append(c);
                    continue;
                }
                w.write(c);
                w.flush();
                for (byte b : buf.toByteArray()) {
                    out.append('%');
                    out.append(ResponseImpl.toDigit(b >> 4 & 0xF));
                    out.append(ResponseImpl.toDigit(b & 0xF));
                }
                buf.reset();
                escaped = true;
            }
            return escaped ? out.toString() : s;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static char toDigit(int n) {
        char ch = Character.forDigit(n, 16);
        if (ch >= 'a') {
            ch = (char)(ch - 97 + 65);
        }
        return ch;
    }
}

