/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.kohsuke.stapler.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FunctionList
implements Iterable<Function> {
    private final Function[] functions;

    public FunctionList(Function ... functions) {
        this.functions = functions;
    }

    public FunctionList(Collection<Function> functions) {
        this.functions = functions.toArray(new Function[0]);
    }

    private FunctionList filter(Filter f) {
        ArrayList<Function> r = new ArrayList<Function>();
        for (Function m : this.functions) {
            if (!f.keep(m)) continue;
            r.add(m);
        }
        return new FunctionList(r.toArray(new Function[0]));
    }

    @Override
    public Iterator<Function> iterator() {
        return Arrays.asList(this.functions).iterator();
    }

    public FunctionList prefix(final String prefix) {
        return this.filter(new Filter(){

            public boolean keep(Function m) {
                return m.getName().startsWith(prefix);
            }
        });
    }

    public FunctionList name(final String name) {
        return this.filter(new Filter(){

            public boolean keep(Function m) {
                return m.getName().equals(name);
            }
        });
    }

    public FunctionList signature(final Class ... args) {
        return this.filter(new Filter(){

            public boolean keep(Function m) {
                return Arrays.equals(m.getParameterTypes(), args);
            }
        });
    }

    public FunctionList signatureStartsWith(final Class ... args) {
        return this.filter(new Filter(){

            public boolean keep(Function m) {
                Class[] params = m.getParameterTypes();
                if (params.length < args.length) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    if (params[i] == args[i]) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static interface Filter {
        public boolean keep(Function var1);
    }
}

