/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Function {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Logger LOGGER = Logger.getLogger(Function.class.getName());

    Function() {
    }

    abstract String getName();

    abstract String getQualifiedName();

    abstract Class[] getParameterTypes();

    abstract Annotation[][] getParameterAnnotatoins();

    abstract String[] getParameterNames();

    Object bindAndInvoke(Object o, StaplerRequest req, StaplerResponse rsp) throws IllegalAccessException, InvocationTargetException, ServletException {
        Class[] types = this.getParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotatoins();
        String[] parameterNames = this.getParameterNames();
        Object[] arguments = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class t = types[i];
            arguments[i] = t == StaplerRequest.class || t == HttpServletRequest.class ? req : (t == StaplerResponse.class || t == HttpServletResponse.class ? rsp : AnnotationHandler.handle(req, annotations[i], i < parameterNames.length ? parameterNames[i] : null, t));
        }
        return this.invoke(req, o, arguments);
    }

    abstract Object invoke(HttpServletRequest var1, Object var2, Object ... var3) throws IllegalAccessException, InvocationTargetException;

    final Function protectBy(Method m) {
        try {
            LimitedTo a = m.getAnnotation(LimitedTo.class);
            if (a == null) {
                return this;
            }
            return new ProtectedFunction(this, a.value());
        }
        catch (LinkageError e) {
            return this;
        }
    }

    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProtectedFunction
    extends Function {
        private final String role;
        private final Function core;

        public ProtectedFunction(Function core, String role) {
            this.role = role;
            this.core = core;
        }

        @Override
        public String getName() {
            return this.core.getName();
        }

        @Override
        String getQualifiedName() {
            return this.core.getQualifiedName();
        }

        @Override
        public Class[] getParameterTypes() {
            return this.core.getParameterTypes();
        }

        @Override
        Annotation[][] getParameterAnnotatoins() {
            return this.core.getParameterAnnotatoins();
        }

        @Override
        String[] getParameterNames() {
            return this.core.getParameterNames();
        }

        @Override
        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            if (req.isUserInRole(this.role)) {
                return this.core.invoke(req, o, args);
            }
            throw new IllegalAccessException("Needs to be in role " + this.role);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotation) {
            return this.core.getAnnotation(annotation);
        }
    }

    static final class StaticFunction
    extends MethodFunction {
        public StaticFunction(Method m) {
            super(m);
        }

        public Class[] getParameterTypes() {
            Class<?>[] p = this.m.getParameterTypes();
            Class[] r = new Class[p.length - 1];
            System.arraycopy(p, 1, r, 0, r.length);
            return r;
        }

        Annotation[][] getParameterAnnotatoins() {
            Annotation[][] a = this.m.getParameterAnnotations();
            Annotation[][] r = new Annotation[a.length - 1][];
            System.arraycopy(a, 1, r, 0, r.length);
            return r;
        }

        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            Object[] r = new Object[args.length + 1];
            r[0] = o;
            System.arraycopy(args, 0, r, 1, args.length);
            return this.m.invoke(null, r);
        }
    }

    static final class InstanceFunction
    extends MethodFunction {
        public InstanceFunction(Method m) {
            super(m);
        }

        public Class[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        Annotation[][] getParameterAnnotatoins() {
            return this.m.getParameterAnnotations();
        }

        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            return this.m.invoke(o, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodFunction
    extends Function {
        protected final Method m;
        private volatile String[] names;

        public MethodFunction(Method m) {
            this.m = m;
        }

        @Override
        public final String getName() {
            return this.m.getName();
        }

        @Override
        String getQualifiedName() {
            return this.m.getDeclaringClass().getName() + '.' + this.getName();
        }

        @Override
        public final <A extends Annotation> A getAnnotation(Class<A> annotation) {
            return this.m.getAnnotation(annotation);
        }

        @Override
        final String[] getParameterNames() {
            if (this.names == null) {
                this.names = this.loadParameterNames(this.m);
            }
            return this.names;
        }

        private String[] loadParameterNames(Method m) {
            Class<?> c = m.getDeclaringClass();
            URL url = c.getClassLoader().getResource(c.getName().replace('.', '/').replace('$', '/') + '/' + m.getName() + ".stapler");
            if (url == null) {
                return EMPTY_ARRAY;
            }
            try {
                return IOUtils.toString((InputStream)url.openStream()).split(",");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + url, e);
                return EMPTY_ARRAY;
            }
        }
    }
}

