/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform;

import java.util.regex.Pattern;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.expression.JexlExpressionEvaluator;

public class TransformationConfig {
    private static final String EXPRESSION_PART = "(.+?)";
    private static final String DEFAULT_EXPRESSION_BEGIN = "${";
    private static final String DEFAULT_EXPRESSION_END = "}";
    private static final String DEFAULT_REGEX_EXPRESSION = "\\$\\{[^}]*}";
    private ExpressionEvaluator expressionEvaluator = new JexlExpressionEvaluator();
    private String expressionNotationBegin = "${";
    private String expressionNotationEnd = "}";
    private Pattern expressionNotationPattern = Pattern.compile("\\$\\{[^}]*}");

    public void buildExpressionNotation(String expressionBegin, String expressionEnd) {
        this.expressionNotationBegin = expressionBegin;
        this.expressionNotationEnd = expressionEnd;
        String regexExpression = Pattern.quote(this.expressionNotationBegin) + EXPRESSION_PART + Pattern.quote(this.expressionNotationEnd);
        this.expressionNotationPattern = Pattern.compile(regexExpression);
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public String getExpressionNotationBegin() {
        return this.expressionNotationBegin;
    }

    public String getExpressionNotationEnd() {
        return this.expressionNotationEnd;
    }

    public Pattern getExpressionNotationPattern() {
        return this.expressionNotationPattern;
    }
}

