/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.util.CellRefUtil;

public class CellRef {
    int col;
    int row;
    String sheetName;
    boolean isColAbs;
    boolean isRowAbs;
    boolean ignoreSheetNameInFormat = false;

    public CellRef(String sheetName, int row, int col) {
        this.sheetName = sheetName;
        this.row = row;
        this.col = col;
    }

    public CellRef(int row, int col) {
        this(null, row, col);
    }

    public CellRef(String cellRef) {
        if (cellRef.endsWith("#REF!")) {
            throw new IllegalArgumentException("Cell reference invalid: " + cellRef);
        }
        String[] parts = CellRefUtil.separateRefParts(cellRef);
        this.sheetName = parts[0];
        String colRef = parts[1];
        if (colRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl = this.isColAbs = colRef.charAt(0) == '$';
        if (this.isColAbs) {
            colRef = colRef.substring(1);
        }
        this.col = CellRefUtil.convertColStringToIndex(colRef);
        String rowRef = parts[2];
        if (rowRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl2 = this.isRowAbs = rowRef.charAt(0) == '$';
        if (this.isRowAbs) {
            rowRef = rowRef.substring(1);
        }
        this.row = Integer.parseInt(rowRef) - 1;
    }

    public String getCellName() {
        StringBuffer sb = new StringBuffer(32);
        if (this.sheetName != null && !this.ignoreSheetNameInFormat) {
            CellRefUtil.appendFormat(sb, this.sheetName);
            sb.append('!');
        }
        this.appendCellReference(sb);
        return sb.toString();
    }

    public String getFormattedSheetName() {
        StringBuffer sb = new StringBuffer(32);
        CellRefUtil.appendFormat(sb, this.sheetName);
        return sb.toString();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isIgnoreSheetNameInFormat() {
        return this.ignoreSheetNameInFormat;
    }

    public void setIgnoreSheetNameInFormat(boolean ignoreSheetNameInFormat) {
        this.ignoreSheetNameInFormat = ignoreSheetNameInFormat;
    }

    void appendCellReference(StringBuffer sb) {
        if (this.isColAbs) {
            sb.append('$');
        }
        sb.append(CellRefUtil.convertNumToColString(this.col));
        if (this.isRowAbs) {
            sb.append('$');
        }
        sb.append(this.row + 1);
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellRef cellRef = (CellRef)o;
        if (this.col != cellRef.col) {
            return false;
        }
        if (this.row != cellRef.row) {
            return false;
        }
        return !(this.sheetName != null ? !this.sheetName.equals(cellRef.sheetName) : cellRef.sheetName != null);
    }

    public int hashCode() {
        int result = this.col;
        result = 31 * result + this.row;
        result = 31 * result + (this.sheetName != null ? this.sheetName.hashCode() : 0);
        return result;
    }

    public String toString(boolean ignoreSheetName) {
        boolean currentIgnoreSheetValue = this.ignoreSheetNameInFormat;
        this.ignoreSheetNameInFormat = ignoreSheetName;
        String result = this.getCellName();
        this.ignoreSheetNameInFormat = currentIgnoreSheetValue;
        return result;
    }

    public String toString() {
        return this.getCellName();
    }
}

