/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import org.jxls.common.CellRef;

public class CellRange {
    CellRef startCell;
    int width;
    int height;
    CellRef[][] cells;
    boolean[][] changeMatrix;

    public CellRange(CellRef startCell, int width, int height) {
        String sheetName = startCell.getSheetName();
        this.startCell = startCell;
        this.width = width;
        this.height = height;
        this.cells = new CellRef[height][];
        this.changeMatrix = new boolean[height][];
        for (int row = 0; row < height; ++row) {
            this.cells[row] = new CellRef[width];
            this.changeMatrix[row] = new boolean[width];
            for (int col = 0; col < width; ++col) {
                this.cells[row][col] = new CellRef(sheetName, row, col);
            }
        }
    }

    public CellRef getCell(int row, int col) {
        return this.cells[row][col];
    }

    void setCell(int row, int col, CellRef cellRef) {
        this.cells[row][col] = cellRef;
    }

    public void shiftCellsWithRowBlock(int startRow, int endRow, int col, int colShift) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.cells[i][j] == null || this.cells[i][j].getCol() <= col || this.cells[i][j].getRow() < startRow || this.cells[i][j].getRow() > endRow || this.changeMatrix[i][j]) continue;
                this.cells[i][j].setCol(this.cells[i][j].getCol() + colShift);
                this.changeMatrix[i][j] = true;
            }
        }
    }

    public void shiftCellsWithColBlock(int startCol, int endCol, int row, int rowShift) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.cells[i][j] == null || this.cells[i][j].getRow() <= row || this.cells[i][j].getCol() < startCol || this.cells[i][j].getCol() > endCol || this.changeMatrix[i][j]) continue;
                this.cells[i][j].setRow(this.cells[i][j].getRow() + rowShift);
                this.changeMatrix[i][j] = true;
            }
        }
    }

    public CellRef getStartCell() {
        return this.startCell;
    }

    public void excludeCells(int startCol, int endCol, int startRow, int endRow) {
        for (int row = startRow; row <= endRow; ++row) {
            for (int col = startCol; col <= endCol; ++col) {
                this.cells[row][col] = null;
            }
        }
    }

    public boolean isExcluded(int row, int col) {
        return this.cells[row][col] == null;
    }

    public boolean hasChanged(int row, int col) {
        return this.changeMatrix[row][col];
    }

    public void resetChangeMatrix() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.changeMatrix[i][j] = false;
            }
        }
    }
}

