/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;

public class CellData {
    public static final String USER_FORMULA_PREFIX = "$[";
    public static final String USER_FORMULA_SUFFIX = "]";
    protected static final String REGEX_EXPRESSION = "\\$\\{[^}]*}";
    protected static final Pattern REGEX_EXPRESSION_PATTERN = Pattern.compile("\\$\\{[^}]*}");
    protected CellRef cellRef;
    protected Object cellValue;
    protected CellType cellType;
    protected String cellComment;
    protected String formula;
    protected Object evaluationResult;
    protected CellType targetCellType;
    List<CellRef> targetPos = new ArrayList<CellRef>();

    public CellData(CellRef cellRef) {
        this.cellRef = cellRef;
    }

    public CellData(String sheetName, int row, int col, CellType cellType, Object cellValue) {
        this.cellRef = new CellRef(sheetName, row, col);
        this.cellType = cellType;
        this.cellValue = cellValue;
        this.updateFormulaValue();
    }

    public CellData(CellRef cellRef, CellType cellType, Object cellValue) {
        this.cellRef = cellRef;
        this.cellType = cellType;
        this.cellValue = cellValue;
        this.updateFormulaValue();
    }

    public CellData(String sheetName, int row, int col) {
        this(sheetName, row, col, CellType.BLANK, null);
    }

    public Object evaluate(Context context) {
        this.targetCellType = this.cellType;
        if (this.cellType == CellType.STRING && this.cellValue != null) {
            String strValue = this.cellValue.toString();
            if (CellData.isUserFormula(strValue)) {
                String formulaStr = strValue.substring(2, strValue.length() - 1);
                this.evaluate(formulaStr, context);
                if (this.evaluationResult != null) {
                    this.targetCellType = CellType.FORMULA;
                    this.formula = this.evaluationResult.toString();
                }
            } else {
                this.evaluate(strValue, context);
            }
            if (this.evaluationResult == null) {
                this.targetCellType = CellType.BLANK;
            }
        }
        return this.evaluationResult;
    }

    void evaluate(String strValue, Context context) {
        StringBuffer sb = new StringBuffer();
        Matcher exprMatcher = REGEX_EXPRESSION_PATTERN.matcher(strValue);
        JexlExpressionEvaluator evaluator = new JexlExpressionEvaluator(context.toMap());
        Object lastMatchEvalResult = null;
        int matchCount = 0;
        int endOffset = 0;
        while (exprMatcher.find()) {
            endOffset = exprMatcher.end();
            ++matchCount;
            String matchedString = exprMatcher.group();
            String expression = matchedString.substring(2, matchedString.length() - 1);
            lastMatchEvalResult = evaluator.evaluate(expression);
            exprMatcher.appendReplacement(sb, Matcher.quoteReplacement(lastMatchEvalResult != null ? lastMatchEvalResult.toString() : ""));
        }
        if (matchCount > 1 || matchCount == 1 && endOffset < strValue.length()) {
            exprMatcher.appendTail(sb);
            this.evaluationResult = sb.toString();
        } else if (matchCount == 1) {
            this.evaluationResult = lastMatchEvalResult;
            if (this.evaluationResult instanceof Number) {
                this.targetCellType = CellType.NUMBER;
            } else if (this.evaluationResult instanceof Boolean) {
                this.targetCellType = CellType.BOOLEAN;
            } else if (this.evaluationResult instanceof Date) {
                this.targetCellType = CellType.DATE;
            }
        } else if (matchCount == 0) {
            this.evaluationResult = strValue;
        }
    }

    public String getCellComment() {
        return this.cellComment;
    }

    public void setCellComment(String cellComment) {
        this.cellComment = cellComment;
    }

    public String getSheetName() {
        return this.cellRef.getSheetName();
    }

    protected void updateFormulaValue() {
        if (this.cellType == CellType.FORMULA) {
            this.formula = this.cellValue != null ? this.cellValue.toString() : "";
        } else if (this.cellType == CellType.STRING && this.cellValue != null && CellData.isUserFormula(this.cellValue.toString())) {
            this.formula = this.cellValue.toString().substring(2, this.cellValue.toString().length() - 1);
        }
    }

    public CellRef getCellRef() {
        return this.cellRef;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public void setCellType(CellType cellType) {
        this.cellType = cellType;
    }

    public Object getCellValue() {
        return this.cellValue;
    }

    public int getRow() {
        return this.cellRef.getRow();
    }

    public int getCol() {
        return this.cellRef.getCol();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean isFormulaCell() {
        return this.formula != null;
    }

    public static boolean isUserFormula(String str) {
        return str.startsWith(USER_FORMULA_PREFIX) && str.endsWith(USER_FORMULA_SUFFIX);
    }

    public boolean addTargetPos(CellRef cellRef) {
        return this.targetPos.add(cellRef);
    }

    public List<CellRef> getTargetPos() {
        return this.targetPos;
    }

    public void resetTargetPos() {
        this.targetPos.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellData)) {
            return false;
        }
        CellData cellData = (CellData)o;
        if (this.cellType != cellData.cellType) {
            return false;
        }
        if (this.cellValue != null ? !this.cellValue.equals(cellData.cellValue) : cellData.cellValue != null) {
            return false;
        }
        return !(this.cellRef != null ? !this.cellRef.equals(cellData.cellRef) : cellData.cellRef != null);
    }

    public int hashCode() {
        int result = this.cellRef != null ? this.cellRef.hashCode() : 0;
        result = 31 * result + (this.cellValue != null ? this.cellValue.hashCode() : 0);
        result = 31 * result + (this.cellType != null ? this.cellType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CellData{" + this.cellRef + ", cellType=" + (Object)((Object)this.cellType) + ", cellValue=" + this.cellValue + '}';
    }

    public static enum CellType {
        STRING,
        NUMBER,
        BOOLEAN,
        DATE,
        FORMULA,
        BLANK,
        ERROR;

    }
}

