/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.Collection;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.CellRefGenerator;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.util.Util;

public class EachCommand
extends AbstractCommand {
    String var;
    String items;
    String select;
    Area area;
    Direction direction = Direction.DOWN;
    CellRefGenerator cellRefGenerator;

    public EachCommand() {
    }

    public EachCommand(String var, String items, Direction direction) {
        this.var = var;
        this.items = items;
        this.direction = direction == null ? Direction.DOWN : direction;
    }

    public EachCommand(String var, String items, Area area) {
        this(var, items, area, Direction.DOWN);
    }

    public EachCommand(String var, String items, Area area, Direction direction) {
        this(var, items, direction);
        if (area != null) {
            this.area = area;
            this.addArea(this.area);
        }
    }

    public EachCommand(String var, String items, Area area, CellRefGenerator cellRefGenerator) {
        this(var, items, area, (Direction)null);
        this.cellRefGenerator = cellRefGenerator;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public CellRefGenerator getCellRefGenerator() {
        return this.cellRefGenerator;
    }

    public void setCellRefGenerator(CellRefGenerator cellRefGenerator) {
        this.cellRefGenerator = cellRefGenerator;
    }

    @Override
    public String getName() {
        return "each";
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    @Override
    public Command addArea(Area area) {
        if (area == null) {
            return this;
        }
        if (this.areaList.size() >= 1) {
            throw new IllegalArgumentException("You can add only a single area to 'each' command");
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        Collection itemsCollection = this.calculateItemsCollection(context);
        int width = 0;
        int height = 0;
        int index = 0;
        CellRef currentCell = this.cellRefGenerator != null ? this.cellRefGenerator.generateCellRef(index, context) : cellRef;
        JexlExpressionEvaluator selectEvaluator = null;
        if (this.select != null) {
            selectEvaluator = new JexlExpressionEvaluator(this.select);
        }
        for (Object obj : itemsCollection) {
            context.putVar(this.var, obj);
            if (selectEvaluator != null && !Util.isConditionTrue(selectEvaluator, context).booleanValue()) {
                context.removeVar(this.var);
                continue;
            }
            Size size = this.area.applyAt(currentCell, context);
            ++index;
            if (this.cellRefGenerator != null) {
                width = Math.max(width, size.getWidth());
                height = Math.max(height, size.getHeight());
                currentCell = this.cellRefGenerator.generateCellRef(index, context);
            } else if (this.direction == Direction.DOWN) {
                currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow() + size.getHeight(), currentCell.getCol());
                width = Math.max(width, size.getWidth());
                height += size.getHeight();
            } else {
                currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
                width += size.getWidth();
                height = Math.max(height, size.getHeight());
            }
            context.removeVar(this.var);
        }
        return new Size(width, height);
    }

    protected Collection calculateItemsCollection(Context context) {
        JexlExpressionEvaluator expressionEvaluator = new JexlExpressionEvaluator(context.toMap());
        Object itemsObject = expressionEvaluator.evaluate(this.items);
        if (!(itemsObject instanceof Collection)) {
            throw new RuntimeException("items expression is not a collection");
        }
        return (Collection)itemsObject;
    }

    public static enum Direction {
        RIGHT,
        DOWN;

    }
}

