/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.builder.xls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.area.XlsArea;
import org.jxls.builder.AreaBuilder;
import org.jxls.builder.xls.AreaCommand;
import org.jxls.command.Command;
import org.jxls.command.EachCommand;
import org.jxls.command.IfCommand;
import org.jxls.command.ImageCommand;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsCommentAreaBuilder
implements AreaBuilder {
    static Logger logger = LoggerFactory.getLogger(XlsCommentAreaBuilder.class);
    public static final String COMMAND_PREFIX = "jx:";
    private static final String ATTR_PREFIX = "(";
    private static final String ATTR_SUFFIX = ")";
    private static final String ATTR_REGEX = "\\s*\\w+\\s*=\\s*([\"|'])(?:(?!\\1).)*\\1";
    private static final Pattern ATTR_REGEX_PATTERN = Pattern.compile("\\s*\\w+\\s*=\\s*([\"|'])(?:(?!\\1).)*\\1");
    private static final String AREAS_ATTR_REGEX = "areas\\s*=\\[[^]]*]";
    private static final Pattern AREAS_ATTR_REGEX_PATTERN = Pattern.compile("areas\\s*=\\[[^]]*]");
    private static Map<String, Class> commandMap = new HashMap<String, Class>();
    private static final String LAST_CELL_ATTR_NAME = "lastCell";
    Transformer transformer;

    public XlsCommentAreaBuilder(Transformer transformer) {
        this.transformer = transformer;
    }

    public static void addCommandMapping(String commandName, Class clazz) {
        commandMap.put(commandName, clazz);
    }

    @Override
    public List<Area> build() {
        ArrayList<Area> userAreas = new ArrayList<Area>();
        List<CellData> commentedCells = this.transformer.getCommentedCells();
        ArrayList<CommandData> allCommands = new ArrayList<CommandData>();
        ArrayList<Area> allAreas = new ArrayList<Area>();
        for (CellData cellData : commentedCells) {
            String comment = cellData.getCellComment();
            List<CommandData> commandDatas = this.buildCommands(cellData, comment);
            for (CommandData commandData : commandDatas) {
                if (commandData.getCommand() instanceof AreaCommand) {
                    XlsArea userArea = new XlsArea(commandData.getAreaRef(), this.transformer);
                    allAreas.add(userArea);
                    userAreas.add(userArea);
                    continue;
                }
                List<Area> areas = commandData.getCommand().getAreaList();
                allAreas.addAll(areas);
                allCommands.add(commandData);
            }
        }
        for (int i = 0; i < allCommands.size(); ++i) {
            CommandData commandData = (CommandData)allCommands.get(i);
            AreaRef commandAreaRef = commandData.getAreaRef();
            List<Area> commandAreas = commandData.getCommand().getAreaList();
            Area minArea = null;
            ArrayList<Area> minAreas = new ArrayList<Area>();
            for (Area area : allAreas) {
                if (commandAreas.contains(area) || !area.getAreaRef().contains(commandAreaRef)) continue;
                boolean belongsToNextCommand = false;
                for (int j = i + 1; j < allCommands.size(); ++j) {
                    CommandData nextCommand = (CommandData)allCommands.get(j);
                    if (!nextCommand.getCommand().getAreaList().contains(area)) continue;
                    belongsToNextCommand = true;
                    break;
                }
                if (belongsToNextCommand || minArea != null && !minArea.getAreaRef().contains(area.getAreaRef())) continue;
                if (minArea != null && minArea.equals(area)) {
                    minAreas.add(area);
                    continue;
                }
                minArea = area;
                minAreas.clear();
                minAreas.add(minArea);
            }
            for (Area area : minAreas) {
                area.addCommand(commandData.getAreaRef(), commandData.getCommand());
            }
        }
        return userAreas;
    }

    private List<CommandData> buildCommands(CellData cellData, String text) {
        String[] commentLines = text.split("\\n");
        ArrayList<CommandData> commandDatas = new ArrayList<CommandData>();
        for (String commentLine : commentLines) {
            Map<String, String> attrMap;
            String line = commentLine.trim();
            if (!XlsCommentAreaBuilder.isCommandString(line)) continue;
            int nameEndIndex = line.indexOf(ATTR_PREFIX, COMMAND_PREFIX.length());
            if (nameEndIndex < 0) {
                String errMsg = "Failed to parse command line [" + line + "]. Expected '" + ATTR_PREFIX + "' symbol.";
                logger.error(errMsg);
                throw new IllegalStateException(errMsg);
            }
            String commandName = line.substring(COMMAND_PREFIX.length(), nameEndIndex).trim();
            CommandData commandData = this.createCommandData(cellData, commandName, attrMap = this.buildAttrMap(line, nameEndIndex));
            if (commandData == null) continue;
            commandDatas.add(commandData);
            List<Area> areas = this.buildAreas(cellData, line);
            for (Area area : areas) {
                commandData.getCommand().addArea(area);
            }
            if (!areas.isEmpty()) continue;
            XlsArea area = new XlsArea(commandData.getAreaRef(), this.transformer);
            commandData.getCommand().addArea(area);
        }
        return commandDatas;
    }

    public static boolean isCommandString(String str) {
        return str.startsWith(COMMAND_PREFIX);
    }

    private List<Area> buildAreas(CellData cellData, String commandLine) {
        ArrayList<Area> areas = new ArrayList<Area>();
        Matcher areasAttrMatcher = AREAS_ATTR_REGEX_PATTERN.matcher(commandLine);
        if (areasAttrMatcher.find()) {
            String areasAttr = areasAttrMatcher.group();
            List<AreaRef> areaRefs = this.extractAreaRefs(cellData, areasAttr);
            for (AreaRef areaRef : areaRefs) {
                XlsArea area = new XlsArea(areaRef, this.transformer);
                areas.add(area);
            }
        }
        return areas;
    }

    private List<AreaRef> extractAreaRefs(CellData cellData, String areasAttr) {
        ArrayList<AreaRef> areaRefs = new ArrayList<AreaRef>();
        Matcher areaRefMatcher = Util.regexAreaRefPattern.matcher(areasAttr);
        while (areaRefMatcher.find()) {
            String areaRefName = areaRefMatcher.group();
            AreaRef areaRef = new AreaRef(areaRefName);
            if (areaRef.getSheetName() == null || areaRef.getSheetName().trim().length() == 0) {
                areaRef.getFirstCellRef().setSheetName(cellData.getSheetName());
            }
            areaRefs.add(areaRef);
        }
        return areaRefs;
    }

    private Map<String, String> buildAttrMap(String commandLine, int nameEndIndex) {
        int paramsEndIndex = commandLine.lastIndexOf(ATTR_SUFFIX);
        if (paramsEndIndex < 0) {
            String errMsg = "Failed to parse command line [" + commandLine + "]. Expected '" + ATTR_SUFFIX + "' symbol.";
            logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        String attrString = commandLine.substring(nameEndIndex + 1, paramsEndIndex).trim();
        return this.parseCommandAttributes(attrString);
    }

    private CommandData createCommandData(CellData cellData, String commandName, Map<String, String> attrMap) {
        Class clazz = commandMap.get(commandName);
        if (clazz == null) {
            logger.warn("Failed to find Command class mapped to command name '" + commandName + "'");
            return null;
        }
        try {
            Command command = (Command)clazz.newInstance();
            for (Map.Entry<String, String> attr : attrMap.entrySet()) {
                if (attr.getKey().equals(LAST_CELL_ATTR_NAME)) continue;
                Util.setObjectProperty(command, attr.getKey(), attr.getValue(), true);
            }
            String lastCellRef = attrMap.get(LAST_CELL_ATTR_NAME);
            if (lastCellRef == null) {
                logger.warn("Failed to find last cell ref attribute 'lastCell' for command '" + commandName + "' in cell " + cellData.getCellRef());
                return null;
            }
            CellRef lastCell = new CellRef(lastCellRef);
            if (lastCell.getSheetName() == null || lastCell.getSheetName().trim().length() == 0) {
                lastCell.setSheetName(cellData.getSheetName());
            }
            return new CommandData(new AreaRef(cellData.getCellRef(), lastCell), command);
        }
        catch (Exception e) {
            logger.warn("Failed to instantiate command class '" + clazz.getName() + "' mapped to command name '" + commandName + "'", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> parseCommandAttributes(String attrString) {
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        Matcher attrMatcher = ATTR_REGEX_PATTERN.matcher(attrString);
        while (attrMatcher.find()) {
            String attrData = attrMatcher.group();
            int attrNameEndIndex = attrData.indexOf("=");
            String attrName = attrData.substring(0, attrNameEndIndex).trim();
            String attrValuePart = attrData.substring(attrNameEndIndex + 1).trim();
            String attrValue = attrValuePart.substring(1, attrValuePart.length() - 1);
            attrMap.put(attrName, attrValue);
        }
        return attrMap;
    }

    static {
        commandMap.put("each", EachCommand.class);
        commandMap.put("if", IfCommand.class);
        commandMap.put("area", AreaCommand.class);
        commandMap.put("image", ImageCommand.class);
    }
}

