/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.command.Command;
import org.jxls.common.AreaListener;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRange;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsArea
implements Area {
    static Logger logger = LoggerFactory.getLogger(XlsArea.class);
    public static final XlsArea EMPTY_AREA = new XlsArea(new CellRef(null, 0, 0), Size.ZERO_SIZE);
    List<CommandData> commandDataList = new ArrayList<CommandData>();
    Transformer transformer;
    CellRange cellRange;
    CellRef startCellRef;
    Size size;
    List<AreaListener> areaListeners = new ArrayList<AreaListener>();
    private boolean cellsCleared = false;

    public XlsArea(AreaRef areaRef, Transformer transformer) {
        CellRef startCell = areaRef.getFirstCellRef();
        CellRef endCell = areaRef.getLastCellRef();
        this.startCellRef = startCell;
        this.size = new Size(endCell.getCol() - startCell.getCol() + 1, endCell.getRow() - startCell.getRow() + 1);
        this.transformer = transformer;
    }

    public XlsArea(String areaRef, Transformer transformer) {
        this(new AreaRef(areaRef), transformer);
    }

    public XlsArea(CellRef startCell, CellRef endCell, Transformer transformer) {
        this(new AreaRef(startCell, endCell), transformer);
    }

    public XlsArea(CellRef startCellRef, Size size, List<CommandData> commandDataList, Transformer transformer) {
        this.startCellRef = startCellRef;
        this.size = size;
        this.commandDataList = commandDataList != null ? commandDataList : new ArrayList();
        this.transformer = transformer;
    }

    public XlsArea(CellRef startCellRef, Size size) {
        this(startCellRef, size, null, null);
    }

    public XlsArea(CellRef startCellRef, Size size, Transformer transformer) {
        this(startCellRef, size, null, transformer);
    }

    @Override
    public void addCommand(AreaRef areaRef, Command command) {
        AreaRef thisAreaRef = new AreaRef(this.startCellRef, this.size);
        if (!thisAreaRef.contains(areaRef)) {
            throw new IllegalArgumentException("Cannot add command '" + command.getName() + "' to area " + thisAreaRef + " at " + areaRef);
        }
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    public void addCommand(String areaRef, Command command) {
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    @Override
    public List<CommandData> getCommandDataList() {
        return this.commandDataList;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private void createCellRange() {
        this.cellRange = new CellRange(this.startCellRef, this.size.getWidth(), this.size.getHeight());
        for (CommandData commandData : this.commandDataList) {
            this.cellRange.excludeCells(commandData.getStartCellRef().getCol() - this.startCellRef.getCol(), commandData.getStartCellRef().getCol() - this.startCellRef.getCol() + commandData.getSize().getWidth() - 1, commandData.getStartCellRef().getRow() - this.startCellRef.getRow(), commandData.getStartCellRef().getRow() - this.startCellRef.getRow() + commandData.getSize().getHeight() - 1);
        }
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        logger.debug("Applying XlsArea at {} with {}", (Object)cellRef, (Object)context);
        this.fireBeforeApplyEvent(cellRef, context);
        int widthDelta = 0;
        int heightDelta = 0;
        this.createCellRange();
        if (this.cellRange.getStartCell().getSheetName().equalsIgnoreCase(cellRef.getSheetName())) {
            this.clearCells();
        }
        for (int i = 0; i < this.commandDataList.size(); ++i) {
            this.cellRange.resetChangeMatrix();
            CommandData commandData = this.commandDataList.get(i);
            CellRef newCell = new CellRef(cellRef.getSheetName(), commandData.getStartCellRef().getRow() - this.startCellRef.getRow() + cellRef.getRow(), commandData.getStartCellRef().getCol() - this.startCellRef.getCol() + cellRef.getCol());
            Size initialSize = commandData.getSize();
            Size newSize = commandData.getCommand().applyAt(newCell, context);
            int widthChange = newSize.getWidth() - initialSize.getWidth();
            int heightChange = newSize.getHeight() - initialSize.getHeight();
            if (widthChange == 0 && heightChange == 0) continue;
            widthDelta += widthChange;
            heightDelta += heightChange;
            if (widthChange != 0) {
                this.cellRange.shiftCellsWithRowBlock(commandData.getStartCellRef().getRow() - this.startCellRef.getRow(), commandData.getStartCellRef().getRow() - this.startCellRef.getRow() + commandData.getSize().getHeight(), commandData.getStartCellRef().getCol() - this.startCellRef.getCol() + initialSize.getWidth(), widthChange);
            }
            if (heightChange != 0) {
                this.cellRange.shiftCellsWithColBlock(commandData.getStartCellRef().getCol() - this.startCellRef.getCol(), commandData.getStartCellRef().getCol() - this.startCellRef.getCol() + newSize.getWidth() - 1, commandData.getStartCellRef().getRow() - this.startCellRef.getRow() + commandData.getSize().getHeight() - 1, heightChange);
            }
            for (int j = i + 1; j < this.commandDataList.size(); ++j) {
                CommandData data = this.commandDataList.get(j);
                int newRow = data.getStartCellRef().getRow() - this.startCellRef.getRow() + cellRef.getRow();
                int newCol = data.getStartCellRef().getCol() - this.startCellRef.getCol() + cellRef.getCol();
                if (newRow > newCell.getRow() && (newCol >= newCell.getCol() && newCol <= newCell.getCol() + newSize.getWidth() || newCol + data.getSize().getWidth() >= newCell.getCol() && newCol + data.getSize().getWidth() <= newCell.getCol() + newSize.getWidth() || newCell.getCol() >= newCol && newCell.getCol() <= newCol + data.getSize().getWidth())) {
                    this.cellRange.shiftCellsWithColBlock(data.getStartCellRef().getCol() - this.startCellRef.getCol(), data.getStartCellRef().getCol() - this.startCellRef.getCol() + data.getSize().getWidth() - 1, data.getStartCellRef().getRow() - this.startCellRef.getRow() + data.getSize().getHeight() - 1, heightChange);
                    data.setStartCellRef(new CellRef(data.getStartCellRef().getSheetName(), data.getStartCellRef().getRow() + heightChange, data.getStartCellRef().getCol()));
                    continue;
                }
                if (newCol <= newCell.getCol() || !(newRow >= newCell.getRow() && newRow <= newCell.getRow() + newSize.getHeight() || newRow + data.getSize().getHeight() >= newCell.getRow() && newRow + data.getSize().getHeight() <= newCell.getRow() + newSize.getHeight()) && (newCell.getRow() < newRow || newCell.getRow() > newRow + data.getSize().getHeight())) continue;
                this.cellRange.shiftCellsWithRowBlock(data.getStartCellRef().getRow() - this.startCellRef.getRow(), data.getStartCellRef().getRow() - this.startCellRef.getRow() + data.getSize().getHeight() - 1, data.getStartCellRef().getCol() - this.startCellRef.getCol() + initialSize.getWidth(), widthChange);
                data.setStartCellRef(new CellRef(data.getStartCellRef().getSheetName(), data.getStartCellRef().getRow(), data.getStartCellRef().getCol() + widthChange));
            }
        }
        this.transformStaticCells(cellRef, context);
        this.fireAfterApplyEvent(cellRef, context);
        return new Size(this.size.getWidth() + widthDelta, this.size.getHeight() + heightDelta);
    }

    private void fireBeforeApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeApplyAtCell(cellRef, context);
        }
    }

    private void fireAfterApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterApplyAtCell(cellRef, context);
        }
    }

    public void clearCells() {
        if (this.cellsCleared) {
            return;
        }
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int row = 0; row < this.size.getHeight(); ++row) {
            for (int col = 0; col < this.size.getWidth(); ++col) {
                CellRef cellRef = new CellRef(sheetName, startRow + row, startCol + col);
                this.transformer.clearCell(cellRef);
            }
        }
        this.cellsCleared = true;
    }

    private void transformStaticCells(CellRef cellRef, Context context) {
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = 0; row < this.size.getHeight(); ++row) {
                if (this.cellRange.isExcluded(row, col)) continue;
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = new CellRef(sheetName, startRow + row, startCol + col);
                CellRef targetCell = new CellRef(cellRef.getSheetName(), relativeCell.getRow() + cellRef.getRow(), relativeCell.getCol() + cellRef.getCol());
                this.fireBeforeTransformCell(srcCell, targetCell, context);
                try {
                    this.transformer.transform(srcCell, targetCell, context);
                }
                catch (Exception e) {
                    logger.error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                this.fireAfterTransformCell(srcCell, targetCell, context);
            }
        }
    }

    private void fireBeforeTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeTransformCell(srcCell, targetCell, context);
        }
    }

    private void fireAfterTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterTransformCell(srcCell, targetCell, context);
        }
    }

    @Override
    public CellRef getStartCellRef() {
        return this.startCellRef;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public AreaRef getAreaRef() {
        return new AreaRef(this.startCellRef, this.size);
    }

    @Override
    public void processFormulas() {
        Set<CellData> formulaCells = this.transformer.getFormulaCells();
        for (CellData formulaCellData : formulaCells) {
            List<String> formulaCellRefs = Util.getFormulaCellRefs(formulaCellData.getFormula());
            List<String> jointedCellRefs = Util.getJointedCellRefs(formulaCellData.getFormula());
            List<CellRef> targetFormulaCells = this.transformer.getTargetCellRef(formulaCellData.getCellRef());
            HashMap<CellRef, List<CellRef>> targetCellRefMap = new HashMap<CellRef, List<CellRef>>();
            HashMap jointedCellRefMap = new HashMap();
            for (String cellRef : formulaCellRefs) {
                CellRef pos = new CellRef(cellRef);
                if (pos.getSheetName() == null) {
                    pos.setSheetName(formulaCellData.getSheetName());
                    pos.setIgnoreSheetNameInFormat(true);
                }
                List<CellRef> targetCellDataList = this.transformer.getTargetCellRef(pos);
                targetCellRefMap.put(pos, targetCellDataList);
            }
            for (String jointedCellRef : jointedCellRefs) {
                List<String> nestedCellRefs = Util.getCellRefsFromJointedCellRef(jointedCellRef);
                ArrayList<CellRef> jointedCellRefList = new ArrayList<CellRef>();
                for (String cellRef : nestedCellRefs) {
                    CellRef pos = new CellRef(cellRef);
                    if (pos.getSheetName() == null) {
                        pos.setSheetName(formulaCellData.getSheetName());
                        pos.setIgnoreSheetNameInFormat(true);
                    }
                    List<CellRef> targetCellDataList = this.transformer.getTargetCellRef(pos);
                    jointedCellRefList.addAll(targetCellDataList);
                }
                jointedCellRefMap.put(jointedCellRef, jointedCellRefList);
            }
            for (int i = 0; i < targetFormulaCells.size(); ++i) {
                String replacementString;
                List<CellRef> range;
                List<List<CellRef>> rangeList;
                CellRef targetFormulaCellRef = targetFormulaCells.get(i);
                String targetFormulaString = formulaCellData.getFormula();
                for (Map.Entry<CellRef, List<CellRef>> entry : targetCellRefMap.entrySet()) {
                    List targetCells = (List)entry.getValue();
                    if (targetCells.isEmpty()) continue;
                    if (targetCells.size() == targetFormulaCells.size()) {
                        CellRef targetCellRefCellRef = (CellRef)targetCells.get(i);
                        targetFormulaString = targetFormulaString.replaceAll("(?<!U_\\([^)]{0,100})" + this.sheetNameRegex(entry) + Pattern.quote(entry.getKey().getCellName()), Matcher.quoteReplacement(targetCellRefCellRef.getCellName()));
                        continue;
                    }
                    rangeList = Util.groupByRanges(targetCells, targetFormulaCells.size());
                    if (rangeList.size() == targetFormulaCells.size()) {
                        range = rangeList.get(i);
                        replacementString = Util.createTargetCellRef(range);
                        targetFormulaString = targetFormulaString.replaceAll("(?<!U_\\([^)]{0,100})" + this.sheetNameRegex(entry) + Pattern.quote(entry.getKey().getCellName()), Matcher.quoteReplacement(replacementString));
                        continue;
                    }
                    targetFormulaString = targetFormulaString.replaceAll("(?<!U_\\([^)]{0,100})" + this.sheetNameRegex(entry) + Pattern.quote(entry.getKey().getCellName()), Matcher.quoteReplacement(Util.createTargetCellRef(targetCells)));
                }
                for (Map.Entry entry : jointedCellRefMap.entrySet()) {
                    List targetCellRefList = (List)entry.getValue();
                    if (targetCellRefList.isEmpty()) continue;
                    rangeList = Util.groupByRanges(targetCellRefList, targetFormulaCells.size());
                    if (rangeList.size() == targetFormulaCells.size()) {
                        range = rangeList.get(i);
                        replacementString = Util.createTargetCellRef(range);
                        targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)entry.getKey()), replacementString);
                        continue;
                    }
                    targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)entry.getKey()), Util.createTargetCellRef(targetCellRefList));
                }
                String sheetNameReplacementRegex = targetFormulaCellRef.getFormattedSheetName() + '!';
                targetFormulaString = targetFormulaString.replaceAll(sheetNameReplacementRegex, "");
                this.transformer.setFormula(new CellRef(targetFormulaCellRef.getSheetName(), targetFormulaCellRef.getRow(), targetFormulaCellRef.getCol()), targetFormulaString);
            }
        }
    }

    @Override
    public void addAreaListener(AreaListener listener) {
        this.areaListeners.add(listener);
    }

    @Override
    public List<AreaListener> getAreaListeners() {
        return this.areaListeners;
    }

    @Override
    public List<Command> findCommandByName(String name) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (CommandData commandData : this.commandDataList) {
            if (name == null || !name.equals(commandData.getCommand().getName())) continue;
            commands.add(commandData.getCommand());
        }
        return commands;
    }

    @Override
    public void reset() {
        for (CommandData commandData : this.commandDataList) {
            commandData.reset();
        }
        this.transformer.resetTargetCellRefs();
    }

    private String sheetNameRegex(Map.Entry<CellRef, List<CellRef>> cellRefEntry) {
        return cellRefEntry.getKey().isIgnoreSheetNameInFormat() ? "(?<!!)" : "";
    }
}

