/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNStatusReporter
implements ISVNReporterBaton,
ISVNReporter {
    private ISVNReporter myReporter;
    private ISVNReporterBaton myBaton;
    private String myRepositoryLocation;
    private SVNRepository myRepository;
    private SVNURL myRepositoryRoot;
    private Map myLocks;
    private SVNStatusEditor myEditor;

    public SVNStatusReporter(SVNRepository repos, ISVNReporterBaton baton, SVNStatusEditor editor) {
        this.myBaton = baton;
        this.myRepository = repos;
        this.myRepositoryLocation = repos.getLocation().toString();
        this.myEditor = editor;
        this.myLocks = new HashMap();
    }

    public SVNLock getLock(SVNURL url) {
        String root;
        if (this.myRepositoryRoot == null || this.myLocks.isEmpty() || url == null) {
            return null;
        }
        String urlString = url.getPath();
        String path = urlString.equals(root = this.myRepositoryRoot.getPath()) ? "/" : urlString.substring(root.length());
        return (SVNLock)this.myLocks.get(path);
    }

    public void report(ISVNReporter reporter) throws SVNException {
        this.myReporter = reporter;
        this.myBaton.report(this);
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.myReporter.setPath(path, lockToken, revision, startEmpty);
    }

    public void deletePath(String path) throws SVNException {
        this.myReporter.deletePath(path);
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revison, boolean startEmpty) throws SVNException {
        String rootURL = SVNPathUtil.getCommonURLAncestor(url.toString(), this.myRepositoryLocation);
        if (rootURL.length() < this.myRepositoryLocation.length()) {
            this.myRepositoryLocation = rootURL;
        }
        this.myReporter.linkPath(url, path, lockToken, revison, startEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishReport() throws SVNException {
        SVNLock[] locks = null;
        try {
            this.myRepositoryRoot = this.myRepository.getRepositoryRoot(true);
            locks = this.myRepository.getLocks("");
        }
        catch (SVNException e) {
            if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw e;
            }
        }
        finally {
            this.myRepository.closeSession();
        }
        if (locks != null) {
            for (int i = 0; i < locks.length; ++i) {
                SVNLock lock = locks[i];
                this.myLocks.put(lock.getPath(), lock);
            }
        }
        this.myEditor.setRepositoryInfo(this.myRepositoryRoot, this.myLocks);
        this.myReporter.finishReport();
    }

    public void abortReport() throws SVNException {
        this.myReporter.abortReport();
    }
}

