/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class AbstractDiffCallback {
    private SVNAdminAreaInfo myAdminInfo;
    private File myBasePath;
    private Set myDeletedPaths;

    protected AbstractDiffCallback(SVNAdminAreaInfo info) {
        this.myAdminInfo = info;
    }

    public void setBasePath(File path) {
        this.myBasePath = path;
    }

    public abstract boolean isDiffUnversioned();

    public abstract File createTempDirectory() throws SVNException;

    public abstract SVNStatusType propertiesChanged(String var1, Map var2, Map var3) throws SVNException;

    public abstract SVNStatusType[] fileChanged(String var1, File var2, File var3, long var4, long var6, String var8, String var9, Map var10, Map var11) throws SVNException;

    public abstract SVNStatusType[] fileAdded(String var1, File var2, File var3, long var4, long var6, String var8, String var9, Map var10, Map var11) throws SVNException;

    public abstract SVNStatusType fileDeleted(String var1, File var2, File var3, String var4, String var5, Map var6) throws SVNException;

    public abstract SVNStatusType directoryAdded(String var1, long var2) throws SVNException;

    public abstract SVNStatusType directoryDeleted(String var1) throws SVNException;

    protected String getDisplayPath(String path) {
        if (this.myAdminInfo == null) {
            if (this.myBasePath != null) {
                return new File(this.myBasePath, path).getAbsolutePath().replace(File.separatorChar, '/');
            }
            return path.replace(File.separatorChar, '/');
        }
        return this.myAdminInfo.getAnchor().getFile(path).getAbsolutePath().replace(File.separatorChar, '/');
    }

    protected void categorizeProperties(Map original, Map regular, Map entry, Map wc) {
        if (original == null) {
            return;
        }
        for (String name : original.keySet()) {
            if (SVNProperty.isRegularProperty(name) && regular != null) {
                regular.put(name, original.get(name));
                continue;
            }
            if (SVNProperty.isEntryProperty(name) && entry != null) {
                entry.put(name, original.get(name));
                continue;
            }
            if (!SVNProperty.isWorkingCopyProperty(name) || wc == null) continue;
            wc.put(name, original.get(name));
        }
    }

    protected SVNAdminAreaInfo getAdminInfo() {
        return this.myAdminInfo;
    }

    protected SVNWCAccess getWCAccess() {
        return this.getAdminInfo().getWCAccess();
    }

    protected void addDeletedPath(String path) {
        if (this.myDeletedPaths == null) {
            this.myDeletedPaths = new HashSet();
        }
        this.myDeletedPaths.add(path);
    }

    protected boolean isPathDeleted(String path) {
        return this.myDeletedPaths != null && this.myDeletedPaths.contains(path);
    }

    protected void clearDeletedPaths() {
        this.myDeletedPaths = null;
    }
}

