/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;

final class InCondition<T>
extends AbstractCondition {
    private static final JooqLogger log = JooqLogger.getLogger(InCondition.class);
    private static final long serialVersionUID = -1653924248576930761L;
    private static final int IN_LIMIT = 1000;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private final Field<T> field;
    private final Field<?>[] values;
    private final Comparator comparator;

    InCondition(Field<T> field, Field<?>[] values, Comparator comparator) {
        this.field = field;
        this.values = values;
        this.comparator = comparator;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.comparator == Comparator.IN ? CLAUSES_IN : CLAUSES_IN_NOT;
    }

    @Override
    public final void accept(Context<?> ctx) {
        List<Field<?>> list = Arrays.asList(this.values);
        if (list.size() == 0) {
            if (this.comparator == Comparator.IN) {
                ctx.visit(DSL.falseCondition());
            } else {
                ctx.visit(DSL.trueCondition());
            }
        } else if (list.size() > 1000) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sql('(').formatIndentStart().formatNewLine();
                    for (int i = 0; i < list.size(); i += 1000) {
                        if (i > 0) {
                            if (this.comparator == Comparator.IN) {
                                ctx.formatSeparator().keyword("or").sql(' ');
                            } else {
                                ctx.formatSeparator().keyword("and").sql(' ');
                            }
                        }
                        this.toSQLSubValues(ctx, InCondition.padded(ctx, list.subList(i, Math.min(i + 1000, list.size()))));
                    }
                    ctx.formatIndentEnd().formatNewLine().sql(')');
                    break;
                }
                default: {
                    this.toSQLSubValues(ctx, list);
                    break;
                }
            }
        } else {
            this.toSQLSubValues(ctx, InCondition.padded(ctx, list));
        }
    }

    private static List<Field<?>> padded(Context<?> ctx, List<Field<?>> list) {
        return ctx.paramType() == ParamType.INDEXED && Boolean.TRUE.equals(ctx.settings().isInListPadding()) ? new PaddedList(list, Arrays.asList(SQLDialect.FIREBIRD).contains((Object)ctx.family()) ? 1000 : Integer.MAX_VALUE) : list;
    }

    private void toSQLSubValues(Context<?> ctx, List<Field<?>> subValues) {
        ctx.visit(this.field).sql(' ').keyword(this.comparator.toSQL()).sql(" (");
        if (subValues.size() > 1) {
            ctx.formatIndentStart().formatNewLine();
        }
        String separator = "";
        for (Field<?> value : subValues) {
            ctx.sql(separator).formatNewLineAfterPrintMargin().visit(value);
            separator = ", ";
        }
        if (subValues.size() > 1) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }

    private static class PaddedList<T>
    extends AbstractList<T> {
        private final List<T> delegate;
        private final int realSize;
        private final int padSize;

        PaddedList(List<T> delegate, int maxPadding) {
            this.delegate = delegate;
            this.realSize = delegate.size();
            this.padSize = Math.min(maxPadding, this.realSize <= 0 ? 0 : (this.realSize <= 1 ? 1 : (this.realSize <= 2 ? 2 : (this.realSize <= 4 ? 4 : (this.realSize <= 8 ? 8 : (this.realSize <= 16 ? 16 : (this.realSize <= 32 ? 32 : (this.realSize <= 64 ? 64 : (this.realSize <= 128 ? 128 : (this.realSize <= 256 ? 256 : (this.realSize <= 512 ? 512 : (this.realSize <= 1024 ? 1024 : (this.realSize <= 2048 ? 2048 : (this.realSize <= 4096 ? 4096 : (this.realSize <= 8192 ? 8192 : (this.realSize <= 16384 ? 16384 : (this.realSize <= 32768 ? 32768 : (this.realSize <= 65536 ? 65536 : (this.realSize <= 131072 ? 131072 : (this.realSize <= 262144 ? 262144 : (this.realSize <= 524288 ? 524288 : (this.realSize <= 0x100000 ? 0x100000 : (this.realSize <= 0x200000 ? 0x200000 : (this.realSize <= 0x400000 ? 0x400000 : (this.realSize <= 0x800000 ? 0x800000 : (this.realSize <= 0x1000000 ? 0x1000000 : (this.realSize <= 0x2000000 ? 0x2000000 : (this.realSize <= 0x4000000 ? 0x4000000 : (this.realSize <= 0x8000000 ? 0x8000000 : (this.realSize <= 0x10000000 ? 0x10000000 : (this.realSize <= 0x20000000 ? 0x20000000 : (this.realSize <= 0x40000000 ? 0x40000000 : (this.realSize <= Integer.MIN_VALUE ? Integer.MIN_VALUE : this.realSize)))))))))))))))))))))))))))))))));
        }

        @Override
        public T get(int index) {
            return index < this.realSize ? this.delegate.get(index) : this.delegate.get(this.realSize - 1);
        }

        @Override
        public int size() {
            return this.padSize;
        }
    }
}

