/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import org.jooq.Catalog;
import org.jooq.ConstraintFinalStep;
import org.jooq.DDLFlag;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;
import org.jooq.ForeignKey;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;

final class DDL {
    private final DSLContext ctx;
    private final EnumSet<DDLFlag> flags;

    DDL(DSLContext ctx, DDLFlag ... flags) {
        this.ctx = ctx;
        this.flags = EnumSet.noneOf(DDLFlag.class);
        for (DDLFlag flag : flags) {
            this.flags.add(flag);
        }
    }

    final Queries queries(Table<?> table) {
        ArrayList<ConstraintFinalStep> constraints = new ArrayList<ConstraintFinalStep>();
        if (this.flags.contains((Object)DDLFlag.TABLE)) {
            if (this.flags.contains((Object)DDLFlag.PRIMARY_KEY)) {
                for (UniqueKey<?> uniqueKey : table.getKeys()) {
                    if (!uniqueKey.isPrimary()) continue;
                    constraints.add(DSL.constraint(uniqueKey.getName()).primaryKey(uniqueKey.getFieldsArray()));
                }
            }
            if (this.flags.contains((Object)DDLFlag.UNIQUE)) {
                for (UniqueKey<?> uniqueKey : table.getKeys()) {
                    if (uniqueKey.isPrimary()) continue;
                    constraints.add(DSL.constraint(uniqueKey.getName()).unique(uniqueKey.getFieldsArray()));
                }
            }
            if (this.flags.contains((Object)DDLFlag.FOREIGN_KEY)) {
                for (ForeignKey foreignKey : table.getReferences()) {
                    constraints.add(DSL.constraint(foreignKey.getName()).foreignKey(foreignKey.getFieldsArray()).references(foreignKey.getKey().getTable(), foreignKey.getKey().getFieldsArray()));
                }
            }
        }
        return DSL.queries(this.ctx.createTable(table).columns(table.fields()).constraints(constraints));
    }

    final Queries queries(Schema schema) {
        ArrayList<DDLQuery> queries = new ArrayList<DDLQuery>();
        if (this.flags.contains((Object)DDLFlag.SCHEMA) && !StringUtils.isBlank(schema.getName())) {
            queries.add(this.ctx.createSchema(schema.getName()));
        }
        if (this.flags.contains((Object)DDLFlag.TABLE)) {
            for (Table<?> table : schema.getTables()) {
                ArrayList<ConstraintFinalStep> constraints = new ArrayList<ConstraintFinalStep>();
                if (this.flags.contains((Object)DDLFlag.PRIMARY_KEY)) {
                    for (UniqueKey<?> key : table.getKeys()) {
                        if (!key.isPrimary()) continue;
                        constraints.add(DSL.constraint(key.getName()).primaryKey(key.getFieldsArray()));
                    }
                }
                if (this.flags.contains((Object)DDLFlag.UNIQUE)) {
                    for (UniqueKey<?> key : table.getKeys()) {
                        if (key.isPrimary()) continue;
                        constraints.add(DSL.constraint(key.getName()).unique(key.getFieldsArray()));
                    }
                }
                queries.add(this.ctx.createTable(table).columns(table.fields()).constraints(constraints));
            }
            if (this.flags.contains((Object)DDLFlag.FOREIGN_KEY)) {
                for (Table<?> table : schema.getTables()) {
                    for (ForeignKey<?, ?> key : table.getReferences()) {
                        queries.add(this.ctx.alterTable(table).add(DSL.constraint(key.getName()).foreignKey(key.getFieldsArray()).references(key.getKey().getTable(), key.getKey().getFieldsArray())));
                    }
                }
            }
        }
        return DSL.queries(queries);
    }

    final Queries queries(Catalog catalog) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Schema schema : catalog.getSchemas()) {
            queries.addAll(Arrays.asList(this.queries(schema).queries()));
        }
        return DSL.queries(queries);
    }
}

