/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.AttachableInternal;
import org.jooq.Batch;
import org.jooq.BatchBindStep;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.Query;
import org.jooq.TableRecord;
import org.jooq.UpdatableRecord;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.impl.Tools;

final class BatchCRUD
implements Batch {
    private static final long serialVersionUID = -2935544935267715011L;
    private final DSLContext create;
    private final Configuration configuration;
    private final TableRecord<?>[] records;
    private final Action action;

    BatchCRUD(Configuration configuration, Action action, TableRecord<?>[] records) {
        this.create = DSL.using(configuration);
        this.configuration = configuration;
        this.action = action;
        this.records = records;
    }

    @Override
    public final int size() {
        return this.records.length;
    }

    @Override
    public final int[] execute() throws DataAccessException {
        if (SettingsTools.executeStaticStatements(this.configuration.settings())) {
            return this.executeStatic();
        }
        return this.executePrepared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int[] executePrepared() {
        void var6_11;
        LinkedHashMap<Object, ArrayList<Query>> queries = new LinkedHashMap<Object, ArrayList<Query>>();
        QueryCollector collector = new QueryCollector();
        Configuration local = this.configuration.derive(Tools.combine(this.configuration.executeListenerProviders(), new DefaultExecuteListenerProvider(collector)));
        local.data((Object)Tools.DataKey.DATA_OMIT_RETURNING_CLAUSE, true);
        local.settings().setExecuteLogging(false);
        for (int i = 0; i < this.records.length; ++i) {
            Configuration previous = ((AttachableInternal)((Object)this.records[i])).configuration();
            try {
                this.records[i].attach(local);
                this.executeAction(i);
                continue;
            }
            catch (QueryCollectorSignal queryCollectorSignal) {
                Query query = queryCollectorSignal.getQuery();
                String sql = queryCollectorSignal.getSQL();
                if (!query.isExecutable()) continue;
                ArrayList<Query> list = (ArrayList<Query>)queries.get(sql);
                if (list == null) {
                    list = new ArrayList<Query>();
                    queries.put(sql, list);
                }
                list.add(query);
                continue;
            }
            finally {
                this.records[i].attach(previous);
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map.Entry entry : queries.entrySet()) {
            int[] array;
            BatchBindStep batch = this.create.batch((Query)((List)entry.getValue()).get(0));
            for (Query query : (List)entry.getValue()) {
                batch.bind(query.getBindValues().toArray());
            }
            for (int i : array = batch.execute()) {
                result.add(i);
            }
        }
        int[] array = new int[result.size()];
        boolean bl = false;
        while (var6_11 < result.size()) {
            array[var6_11] = (Integer)result.get((int)var6_11);
            ++var6_11;
        }
        this.updateChangedFlag();
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] executeStatic() {
        ArrayList<Query> queries = new ArrayList<Query>();
        QueryCollector collector = new QueryCollector();
        Configuration local = this.configuration.derive(Tools.combine(this.configuration.executeListenerProviders(), new DefaultExecuteListenerProvider(collector)));
        for (int i = 0; i < this.records.length; ++i) {
            Configuration previous = ((AttachableInternal)((Object)this.records[i])).configuration();
            try {
                this.records[i].attach(local);
                this.executeAction(i);
                continue;
            }
            catch (QueryCollectorSignal e) {
                Query query = e.getQuery();
                if (!query.isExecutable()) continue;
                queries.add(query);
                continue;
            }
            finally {
                this.records[i].attach(previous);
            }
        }
        int[] result = this.create.batch(queries).execute();
        this.updateChangedFlag();
        return result;
    }

    private void executeAction(int i) {
        switch (this.action) {
            case STORE: {
                ((UpdatableRecord)this.records[i]).store();
                break;
            }
            case INSERT: {
                this.records[i].insert();
                break;
            }
            case UPDATE: {
                ((UpdatableRecord)this.records[i]).update();
                break;
            }
            case DELETE: {
                ((UpdatableRecord)this.records[i]).delete();
            }
        }
    }

    private final void updateChangedFlag() {
        for (TableRecord<?> record : this.records) {
            record.changed(this.action == Action.DELETE);
            if (!(record instanceof AbstractRecord)) continue;
            ((AbstractRecord)((Object)record)).fetched = this.action != Action.DELETE;
        }
    }

    private static class QueryCollectorSignal
    extends ControlFlowSignal {
        private static final long serialVersionUID = -9047250761846931903L;
        private final String sql;
        private final Query query;

        QueryCollectorSignal(String sql, Query query) {
            this.sql = sql;
            this.query = query;
        }

        String getSQL() {
            return this.sql;
        }

        Query getQuery() {
            return this.query;
        }
    }

    private static class QueryCollector
    extends DefaultExecuteListener {
        private static final long serialVersionUID = 7399239846062763212L;

        private QueryCollector() {
        }

        @Override
        public void renderEnd(ExecuteContext ctx) {
            throw new QueryCollectorSignal(ctx.sql(), ctx.query());
        }
    }

    static enum Action {
        STORE,
        INSERT,
        UPDATE,
        DELETE;

    }
}

