/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.UDTRecord;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.ArrayTableEmulation;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.util.h2.H2DataType;

final class ArrayTable
extends AbstractTable<Record> {
    private static final long serialVersionUID = 2380426377794577041L;
    private final Field<?> array;
    private final Fields<Record> field;
    private final String alias;
    private final String[] fieldAliases;

    ArrayTable(Field<?> array) {
        this(array, "array_table");
    }

    ArrayTable(Field<?> array, String alias) {
        this(array, alias, new String[]{"COLUMN_VALUE"});
    }

    ArrayTable(Field<?> array, String alias, String[] fieldAliases) {
        super(alias);
        Class arrayType = array.getDataType().getType().isArray() ? array.getDataType().getType().getComponentType() : Object.class;
        this.array = array;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.field = ArrayTable.init(arrayType, alias, fieldAliases);
    }

    private static final Fields<Record> init(Class<?> arrayType, String alias, String[] fieldAliases) {
        ArrayList result = new ArrayList();
        if (UDTRecord.class.isAssignableFrom(arrayType)) {
            try {
                UDTRecord record = (UDTRecord)arrayType.newInstance();
                for (Field<?> f : record.fields()) {
                    result.add(DSL.field(DSL.name(alias, f.getName()), f.getDataType()));
                }
            }
            catch (Exception e) {
                throw new DataTypeException("Bad UDT Type : " + arrayType, e);
            }
        } else {
            result.add(DSL.field(DSL.name(alias, "COLUMN_VALUE"), DSL.getDataType(arrayType)));
        }
        return new Fields<Record>(result);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<Record> as(String as) {
        return new ArrayTable(this.array, as);
    }

    @Override
    public final Table<Record> as(String as, String ... fieldAliases) {
        return new ArrayTable(this.array, as, fieldAliases);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    private final Table<Record> table(Configuration configuration) {
        switch (configuration.family()) {
            case H2: {
                return new H2ArrayTable().as(this.alias);
            }
            case HSQLDB: 
            case POSTGRES: {
                return new PostgresHSQLDBTable().as(this.alias, this.fieldAliases);
            }
        }
        if (this.array.getDataType().getType().isArray() && this.array instanceof Param) {
            return this.emulate();
        }
        return DSL.table("{0}", new QueryPart[]{this.array}).as(this.alias);
    }

    private final ArrayTableEmulation emulate() {
        return new ArrayTableEmulation((Object[])((Param)this.array).getValue(), this.alias);
    }

    @Override
    final Fields<Record> fields0() {
        return this.field;
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record> {
        private static final long serialVersionUID = 2662639259338694177L;

        DialectArrayTable() {
            super(ArrayTable.this.alias);
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImpl.class;
        }

        @Override
        public final Table<Record> as(String as) {
            return new TableAlias<Record>(this, as);
        }

        @Override
        public final Table<Record> as(String as, String ... fieldAliases) {
            return new TableAlias<Record>(this, as, fieldAliases);
        }

        @Override
        final Fields<Record> fields0() {
            return ArrayTable.this.fields0();
        }
    }

    private class H2ArrayTable
    extends DialectArrayTable {
        private static final long serialVersionUID = 8679404596822098711L;

        private H2ArrayTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.keyword("table").sql('(').visit(DSL.name(ArrayTable.this.fieldAliases == null || ArrayTable.this.fieldAliases.length == 0 ? "COLUMN_VALUE" : ArrayTable.this.fieldAliases[0])).sql(' ');
            if (ArrayTable.this.array.getDataType().getType() == Object[].class) {
                ctx.keyword(H2DataType.VARCHAR.getTypeName());
            } else {
                ctx.keyword(ArrayTable.this.array.getDataType().getTypeName());
            }
            ctx.sql(" = ").visit(ArrayTable.this.array).sql(')');
        }
    }

    private class PostgresHSQLDBTable
    extends DialectArrayTable {
        private static final long serialVersionUID = 6989279597964488457L;

        private PostgresHSQLDBTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.keyword("unnest").sql('(').visit(ArrayTable.this.array).sql(")");
        }
    }
}

