/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.conf;

import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.jooq.conf.BackslashEscaping;
import org.jooq.conf.ParamType;
import org.jooq.conf.RenderMapping;
import org.jooq.conf.Settings;
import org.jooq.conf.StatementType;
import org.jooq.tools.StringUtils;

public final class SettingsTools {
    private static final Settings DEFAULT_SETTINGS;

    public static final ParamType getParamType(Settings settings) {
        ParamType result;
        if (SettingsTools.executeStaticStatements(settings)) {
            return ParamType.INLINED;
        }
        if (settings != null && (result = settings.getParamType()) != null) {
            return result;
        }
        return ParamType.INDEXED;
    }

    public static final StatementType getStatementType(Settings settings) {
        StatementType result;
        if (settings != null && (result = settings.getStatementType()) != null) {
            return result;
        }
        return StatementType.PREPARED_STATEMENT;
    }

    public static final BackslashEscaping getBackslashEscaping(Settings settings) {
        BackslashEscaping result;
        if (settings != null && (result = settings.getBackslashEscaping()) != null) {
            return result;
        }
        return BackslashEscaping.DEFAULT;
    }

    public static final boolean executePreparedStatements(Settings settings) {
        return SettingsTools.getStatementType(settings) == StatementType.PREPARED_STATEMENT;
    }

    public static final boolean executeStaticStatements(Settings settings) {
        return SettingsTools.getStatementType(settings) == StatementType.STATIC_STATEMENT;
    }

    public static final boolean updatablePrimaryKeys(Settings settings) {
        return StringUtils.defaultIfNull(settings.isUpdatablePrimaryKeys(), false);
    }

    public static final boolean reflectionCaching(Settings settings) {
        return StringUtils.defaultIfNull(settings.isReflectionCaching(), true);
    }

    public static final RenderMapping getRenderMapping(Settings settings) {
        if (settings.getRenderMapping() == null) {
            settings.setRenderMapping(new RenderMapping());
        }
        return settings.getRenderMapping();
    }

    public static final Settings defaultSettings() {
        return SettingsTools.clone(DEFAULT_SETTINGS);
    }

    public static final Settings clone(Settings settings) {
        return (Settings)settings.clone();
    }

    public static int getQueryTimeout(int timeout, Settings settings) {
        return timeout != 0 ? timeout : (settings.getQueryTimeout() != null ? settings.getQueryTimeout() : 0);
    }

    public static int getMaxRows(int maxRows, Settings settings) {
        return maxRows != 0 ? maxRows : (settings.getMaxRows() != null ? settings.getMaxRows() : 0);
    }

    public static int getFetchSize(int fetchSize, Settings settings) {
        return fetchSize != 0 ? fetchSize : (settings.getFetchSize() != null ? settings.getFetchSize() : 0);
    }

    static {
        InputStream in;
        Settings settings = null;
        String property = System.getProperty("org.jooq.settings");
        if (property != null) {
            in = SettingsTools.class.getResourceAsStream(property);
            settings = in != null ? (Settings)JAXB.unmarshal((InputStream)in, Settings.class) : (Settings)JAXB.unmarshal((File)new File(property), Settings.class);
        }
        if (settings == null && (in = SettingsTools.class.getResourceAsStream("/jooq-settings.xml")) != null) {
            settings = (Settings)JAXB.unmarshal((InputStream)in, Settings.class);
        }
        if (settings == null) {
            settings = new Settings();
        }
        DEFAULT_SETTINGS = settings;
    }
}

