/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    public static final Class[] NO_PARAMETERS = new Class[0];
    public static final Object[] NO_ARGUMENTS = new Object[0];
    public static final Type[] NO_TYPES = new Type[0];
    public static final String METHOD_GET_PREFIX = "get";
    public static final String METHOD_IS_PREFIX = "is";
    public static final String METHOD_SET_PREFIX = "set";
    private static Method _getMethod0;

    public static Method getMethod0(Class c, String name, Class ... parameterTypes) {
        try {
            return (Method)_getMethod0.invoke((Object)c, name, parameterTypes);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static Method findMethod(Class c, String methodName) {
        return ReflectUtil.findDeclaredMethod(c, methodName, true);
    }

    public static Method findDeclaredMethod(Class c, String methodName) {
        return ReflectUtil.findDeclaredMethod(c, methodName, false);
    }

    private static Method findDeclaredMethod(Class c, String methodName, boolean publicOnly) {
        Method[] ms;
        if (methodName == null || c == null) {
            return null;
        }
        for (Method m : ms = publicOnly ? c.getMethods() : c.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static Class[] getClasses(Object ... objects) {
        if (objects == null) {
            return null;
        }
        Class[] result = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            result[i] = objects[i].getClass();
        }
        return result;
    }

    public static Object invoke(Class c, Object obj, String method, Class[] paramClasses, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = c.getMethod(method, paramClasses);
        return m.invoke(obj, params);
    }

    public static Object invoke(Object obj, String method, Class[] paramClasses, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = obj.getClass().getMethod(method, paramClasses);
        return m.invoke(obj, params);
    }

    public static Object invoke(Object obj, String method, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class[] paramClass = ReflectUtil.getClasses(params);
        return ReflectUtil.invoke(obj, method, paramClass, params);
    }

    public static Object invoke(Class c, Object obj, String method, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class[] paramClass = ReflectUtil.getClasses(params);
        return ReflectUtil.invoke(c, obj, method, paramClass, params);
    }

    public static Object invokeDeclared(Class c, Object obj, String method, Class[] paramClasses, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = c.getDeclaredMethod(method, paramClasses);
        m.setAccessible(true);
        return m.invoke(obj, params);
    }

    public static Object invokeDeclared(Object obj, String method, Class[] paramClasses, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method m = obj.getClass().getDeclaredMethod(method, paramClasses);
        m.setAccessible(true);
        return m.invoke(obj, params);
    }

    public static Object invokeDeclared(Object obj, String method, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class[] paramClass = ReflectUtil.getClasses(params);
        return ReflectUtil.invokeDeclared(obj, method, paramClass, params);
    }

    public static Object invokeDeclared(Class c, Object obj, String method, Object[] params) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class[] paramClass = ReflectUtil.getClasses(params);
        return ReflectUtil.invokeDeclared(c, obj, method, paramClass, params);
    }

    public static boolean isSubclass(Class thisClass, Class target) {
        if (target.isInterface()) {
            return ReflectUtil.isInterfaceImpl(thisClass, target);
        }
        for (Class x = thisClass; x != null; x = x.getSuperclass()) {
            if (x != target) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterfaceImpl(Class thisClass, Class targetInterface) {
        for (Class x = thisClass; x != null; x = x.getSuperclass()) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = x.getInterfaces()) {
                if (i == targetInterface) {
                    return true;
                }
                if (!ReflectUtil.isInterfaceImpl(i, targetInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInstanceOf(Object o, Class target) {
        return ReflectUtil.isSubclass(o.getClass(), target);
    }

    public static Method[] getAccessibleMethods(Class clazz) {
        return ReflectUtil.getAccessibleMethods(clazz, Object.class);
    }

    public static Method[] getAccessibleMethods(Class clazz, Class limit) {
        Package topPackage = clazz.getPackage();
        ArrayList<Method> methodList = new ArrayList<Method>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                int pckgHash;
                if (Modifier.isVolatile(method.getModifiers())) continue;
                if (top) {
                    methodList.add(method);
                    continue;
                }
                int modifier = method.getModifiers();
                if (Modifier.isPrivate(modifier) || Modifier.isAbstract(modifier)) continue;
                if (Modifier.isPublic(modifier)) {
                    ReflectUtil.addMethodIfNotExist(methodList, method);
                    continue;
                }
                if (Modifier.isProtected(modifier)) {
                    ReflectUtil.addMethodIfNotExist(methodList, method);
                    continue;
                }
                Package pckg = method.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ReflectUtil.addMethodIfNotExist(methodList, method);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Method[] methods = new Method[methodList.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)methodList.get(i);
        }
        return methods;
    }

    private static void addMethodIfNotExist(List<Method> allMethods, Method newMethod) {
        for (Method m : allMethods) {
            if (!ReflectUtil.compareSignatures(m, newMethod)) continue;
            return;
        }
        allMethods.add(newMethod);
    }

    public static Field[] getAccessibleFields(Class clazz) {
        return ReflectUtil.getAccessibleFields(clazz, Object.class);
    }

    public static Field[] getAccessibleFields(Class clazz, Class limit) {
        Package topPackage = clazz.getPackage();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                int pckgHash;
                if (top) {
                    fieldList.add(field);
                    continue;
                }
                int modifier = field.getModifiers();
                if (Modifier.isPrivate(modifier)) continue;
                if (Modifier.isPublic(modifier)) {
                    ReflectUtil.addFieldIfNotExist(fieldList, field);
                    continue;
                }
                if (Modifier.isProtected(modifier)) {
                    ReflectUtil.addFieldIfNotExist(fieldList, field);
                    continue;
                }
                Package pckg = field.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ReflectUtil.addFieldIfNotExist(fieldList, field);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Field[] fields = new Field[fieldList.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (Field)fieldList.get(i);
        }
        return fields;
    }

    private static void addFieldIfNotExist(List<Field> allFields, Field newField) {
        for (Field f : allFields) {
            if (!ReflectUtil.compareSignatures(f, newField)) continue;
            return;
        }
        allFields.add(newField);
    }

    public static Method[] getSupportedMethods(Class clazz) {
        return ReflectUtil.getSupportedMethods(clazz, Object.class);
    }

    public static Method[] getSupportedMethods(Class clazz, Class limit) {
        ArrayList<Method> supportedMethods = new ArrayList<Method>();
        for (Class c = clazz; c != limit; c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                boolean found = false;
                for (Method supportedMethod : supportedMethods) {
                    if (!ReflectUtil.compareSignatures(method, supportedMethod)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                supportedMethods.add(method);
            }
        }
        return supportedMethods.toArray(new Method[supportedMethods.size()]);
    }

    public static Field[] getSupportedFields(Class clazz) {
        return ReflectUtil.getSupportedFields(clazz, Object.class);
    }

    public static Field[] getSupportedFields(Class clazz, Class limit) {
        ArrayList<Field> supportedFields = new ArrayList<Field>();
        for (Class c = clazz; c != limit; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                boolean found = false;
                for (Field supportedField : supportedFields) {
                    if (!ReflectUtil.compareSignatures(field, supportedField)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                supportedFields.add(field);
            }
        }
        return supportedFields.toArray(new Field[supportedFields.size()]);
    }

    public static boolean compareDeclarations(Method first, Method second) {
        if (first.getReturnType() != second.getReturnType()) {
            return false;
        }
        return ReflectUtil.compareSignatures(first, second);
    }

    public static boolean compareSignatures(Method first, Method second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        return ReflectUtil.compareParameters(first.getParameterTypes(), second.getParameterTypes());
    }

    public static boolean compareSignatures(Constructor first, Constructor second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        return ReflectUtil.compareParameters(first.getParameterTypes(), second.getParameterTypes());
    }

    public static boolean compareSignatures(Field first, Field second) {
        return first.getName().equals(second.getName());
    }

    public static boolean compareParameters(Class[] first, Class[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static void forceAccess(AccessibleObject accObject) {
        if (accObject.isAccessible()) {
            return;
        }
        try {
            accObject.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublicPublic(Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(member.getDeclaringClass().getModifiers());
    }

    public static boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static Object newInstance(Class type) throws IllegalAccessException, InstantiationException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return 0;
            }
            if (type == Long.TYPE) {
                return 0L;
            }
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return 0.0;
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            throw new IllegalArgumentException("Invalid primitive type: " + type);
        }
        if (type == Integer.class) {
            return 0;
        }
        if (type == String.class) {
            return "";
        }
        if (type == Long.class) {
            return 0L;
        }
        if (type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Float.class) {
            Float.valueOf(0.0f);
        }
        if (type == Double.class) {
            Double.valueOf(0.0);
        }
        if (type == Map.class) {
            return new HashMap();
        }
        if (type == List.class) {
            return new ArrayList();
        }
        if (type == Set.class) {
            return new LinkedHashSet();
        }
        if (type == Collection.class) {
            return new ArrayList();
        }
        if (type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.class) {
            return (short)0;
        }
        if (type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type.isEnum()) {
            return type.getEnumConstants()[0];
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        return type.newInstance();
    }

    public static boolean isAssignableFrom(Member member1, Member member2) {
        return member1.getDeclaringClass().isAssignableFrom(member2.getDeclaringClass());
    }

    public static Class[] getSuperclasses(Class type) {
        int i = 0;
        for (Class x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            ++i;
        }
        Class[] result = new Class[i];
        i = 0;
        for (Class x = type.getSuperclass(); x != null; x = x.getSuperclass()) {
            result[i] = x;
            ++i;
        }
        return result;
    }

    public static boolean isUserDefinedMethod(Method method) {
        return method.getDeclaringClass() != Object.class;
    }

    public static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }

    public static boolean isBeanProperty(Method method) {
        if (ReflectUtil.isObjectMethod(method)) {
            return false;
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        return methodName.startsWith(METHOD_GET_PREFIX) ? returnType != null && paramTypes.length == 0 : (methodName.startsWith(METHOD_IS_PREFIX) ? returnType != null && paramTypes.length == 0 : methodName.startsWith(METHOD_SET_PREFIX) && paramTypes.length == 1);
    }

    public static boolean isBeanPropertyGetter(Method method) {
        return ReflectUtil.getBeanPropertyGetterPrefixLength(method) != 0;
    }

    private static int getBeanPropertyGetterPrefixLength(Method method) {
        if (ReflectUtil.isObjectMethod(method)) {
            return 0;
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith(METHOD_GET_PREFIX)) {
            if (returnType != null && paramTypes.length == 0) {
                return 3;
            }
        } else if (methodName.startsWith(METHOD_IS_PREFIX) && returnType != null && paramTypes.length == 0) {
            return 2;
        }
        return 0;
    }

    public static String getBeanPropertyGetterName(Method method) {
        int prefixLength = ReflectUtil.getBeanPropertyGetterPrefixLength(method);
        if (prefixLength == 0) {
            return null;
        }
        String methodName = method.getName().substring(prefixLength);
        return Introspector.decapitalize(methodName);
    }

    public static boolean isBeanPropertySetter(Method method) {
        return ReflectUtil.getBeanPropertySetterPrefixLength(method) != 0;
    }

    private static int getBeanPropertySetterPrefixLength(Method method) {
        if (ReflectUtil.isObjectMethod(method)) {
            return 0;
        }
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith(METHOD_SET_PREFIX) && paramTypes.length == 1) {
            return 3;
        }
        return 0;
    }

    public static String getBeanPropertySetterName(Method method) {
        int prefixLength = ReflectUtil.getBeanPropertySetterPrefixLength(method);
        if (prefixLength == 0) {
            return null;
        }
        String methodName = method.getName().substring(prefixLength);
        return Introspector.decapitalize(methodName);
    }

    public static Class getComponentType(Type type) {
        return ReflectUtil.getComponentType(type, -1);
    }

    public static Class getComponentType(Type type, int index) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] generics = pt.getActualTypeArguments();
            if (index < 0) {
                index = generics.length + index;
            }
            if (index < generics.length) {
                return ReflectUtil.toClass(generics[index]);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return ReflectUtil.toClass(gat.getGenericComponentType());
        }
        return null;
    }

    public static Class getGenericSupertype(Class type, int index) {
        return ReflectUtil.getComponentType(type.getGenericSuperclass(), index);
    }

    public static Class getGenericSupertype(Class type) {
        return ReflectUtil.getComponentType(type.getGenericSuperclass());
    }

    public static Class toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return ReflectUtil.toClass(pt.getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] lower = wt.getLowerBounds();
            if (lower.length == 1) {
                return ReflectUtil.toClass(lower[0]);
            }
            Type[] upper = wt.getUpperBounds();
            if (upper.length == 1) {
                return ReflectUtil.toClass(upper[0]);
            }
        } else {
            TypeVariable tv;
            Type[] bounds;
            if (type instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)type;
                Class componentType = ReflectUtil.toClass(gat.getGenericComponentType());
                return Array.newInstance(componentType, 0).getClass();
            }
            if (type instanceof TypeVariable && (bounds = (tv = (TypeVariable)type).getBounds()).length == 1) {
                return ReflectUtil.toClass(bounds[0]);
            }
        }
        return null;
    }

    public static Object readAnnotationValue(Annotation annotation, String name) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    static {
        try {
            _getMethod0 = Class.class.getDeclaredMethod("getMethod0", String.class, Class[].class);
            _getMethod0.setAccessible(true);
        }
        catch (Exception ignore) {
            try {
                _getMethod0 = Class.class.getMethod("getMethod", String.class, Class[].class);
            }
            catch (Exception ignored) {
                _getMethod0 = null;
            }
        }
    }
}

