/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.MultipartRequestInputStream;

public class DiskFileUpload
extends FileUpload {
    protected final File destFolder;
    protected File file;

    DiskFileUpload(MultipartRequestInputStream input, File destinationFolder, int maxFileSize) {
        super(input, maxFileSize);
        this.destFolder = destinationFolder;
    }

    public boolean isInMemory() {
        return false;
    }

    public File getDestinationFolder() {
        return this.destFolder;
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getFileContent() throws IOException {
        return FileUtil.readBytes(this.file);
    }

    public InputStream getFileInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStream() throws IOException {
        this.file = new File(this.destFolder, this.header.getFileName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
        this.size = 0;
        try {
            if (this.maxFileSize == -1) {
                this.size = this.input.copyAll(out);
            } else {
                this.size = this.input.copyMax(out, this.maxFileSize + 1);
                if (this.size > this.maxFileSize) {
                    this.fileTooBig = true;
                    this.valid = false;
                    this.input.skipToBoundary();
                    return;
                }
            }
            this.valid = true;
        }
        finally {
            StreamUtil.close(out);
        }
    }
}

