/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import jodd.bean.BeanUtil;
import jodd.servlet.PageContextThreadLocal;
import jodd.servlet.ServletUtil;

public class JspValueResolver {
    protected final HttpServletRequest servletRequest;
    protected final PageContext pageContext;

    public JspValueResolver(HttpServletRequest servletRequest) {
        this.pageContext = null;
        this.servletRequest = servletRequest;
    }

    public JspValueResolver(PageContext pageContext) {
        this.pageContext = pageContext;
        this.servletRequest = (HttpServletRequest)pageContext.getRequest();
    }

    public Object value(String name) {
        if (this.pageContext != null) {
            return JspValueResolver.resolveValue(name, this.pageContext);
        }
        return JspValueResolver.resolveValue(name, this.servletRequest);
    }

    public static Object resolveValue(String valueName, HttpServletRequest request) {
        return ServletUtil.value(request, valueName);
    }

    public static Object resolveValue(String valueName, PageContext page) {
        return ServletUtil.value(page, valueName);
    }

    public static Object resolveValue(String valueName) {
        return JspValueResolver.resolveValue(valueName, PageContextThreadLocal.get());
    }

    public Object attr(String name) {
        if (this.pageContext != null) {
            return JspValueResolver.resolveAttribute(name, this.pageContext);
        }
        return JspValueResolver.resolveAttribute(name, this.servletRequest);
    }

    public static Object resolveAttribute(String attributeName, HttpServletRequest request) {
        return ServletUtil.attrValue(request, attributeName);
    }

    public static Object resolveAttribute(String attributeName, PageContext page) {
        return ServletUtil.attrValue(page, attributeName);
    }

    public static Object resolveAttribute(String attributeName) {
        return JspValueResolver.resolveAttribute(attributeName, PageContextThreadLocal.get());
    }

    public Object property(String name) {
        if (this.pageContext != null) {
            return JspValueResolver.resolveProperty(name, this.pageContext);
        }
        return JspValueResolver.resolveProperty(name, this.servletRequest);
    }

    public static Object resolveProperty(String name, HttpServletRequest request) {
        String thisRef = BeanUtil.extractThisReference(name);
        Object value = JspValueResolver.resolveValue(thisRef, request);
        if (value == null) {
            return null;
        }
        if (thisRef == name) {
            return value;
        }
        name = "*this" + name.substring(thisRef.length());
        return BeanUtil.getDeclaredPropertySilently(value, name);
    }

    public static Object resolveProperty(String name, PageContext page) {
        String thisRef = BeanUtil.extractThisReference(name);
        Object value = JspValueResolver.resolveValue(thisRef, page);
        if (value == null) {
            return null;
        }
        if (thisRef == name) {
            return value;
        }
        name = "*this" + name.substring(thisRef.length());
        return BeanUtil.getDeclaredPropertySilently(value, name);
    }

    public static Object resolveProperty(String name) {
        return JspValueResolver.resolveProperty(name, PageContextThreadLocal.get());
    }
}

