/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jodd.io.FileNameUtil;
import jodd.io.findfile.FileScanner;
import jodd.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardFileScanner
extends FileScanner {
    protected final String pattern;
    protected List<File> files = new ArrayList<File>();

    public WildcardFileScanner(String pattern) {
        this.pattern = pattern;
    }

    @Override
    protected void onFile(File file) {
        String path = file.getAbsolutePath();
        boolean match = Wildcard.matchPath(path = FileNameUtil.separatorsToUnix(path), this.pattern);
        if (match) {
            this.files.add(file);
        }
    }

    public List<File> getMatchedFiles() {
        return this.files;
    }

    public List<File> list(File root) {
        this.files.clear();
        this.scan(root);
        return this.files;
    }

    public List<File> list(String root) {
        this.files.clear();
        this.scan(root);
        return this.files;
    }
}

