/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.internal.mockups.MockStates;
import mockit.internal.util.ClassLoad;

public final class MockClasses {
    private static final Field INVOKED_INSTANCE_FIELD;
    private static final Method ON_TEAR_DOWN_METHOD;
    @Nonnull
    private final Map<String, MockUp<?>> startupMocks = new IdentityHashMap(8);
    @Nonnull
    private final Map<Class<?>, MockUpInstances> mockupClassesToMockupInstances = new IdentityHashMap();
    @Nonnull
    private final Map<Object, MockUp<?>> mockedToMockupInstances = new IdentityHashMap();
    @Nonnull
    public final MockStates mockStates = new MockStates();

    private static void notifyOfTearDown(@Nonnull MockUp<?> mockUp) {
        try {
            ON_TEAR_DOWN_METHOD.invoke(mockUp, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
        }
    }

    MockClasses() {
    }

    public void addMock(@Nonnull String mockClassDesc, @Nonnull MockUp<?> mockUp) {
        this.startupMocks.put(mockClassDesc, mockUp);
    }

    public void addMock(@Nonnull MockUp<?> mockUp) {
        Class<?> mockUpClass = mockUp.getClass();
        MockUpInstances newData = new MockUpInstances(mockUp);
        this.mockupClassesToMockupInstances.put(mockUpClass, newData);
    }

    public void addMock(@Nonnull MockUp<?> mockUp, @Nonnull Object mockedInstance) {
        MockUp<?> previousMockup = this.mockedToMockupInstances.put(mockedInstance, mockUp);
        assert (previousMockup == null);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUp.getClass());
        mockUpInstances.hasMockupsForSingleInstances = true;
    }

    @Nullable
    MockUp<?> getMock(@Nonnull String mockUpClassDesc, @Nullable Object mockedInstance) {
        MockUp<?> mockUpForSingleInstance;
        if (mockedInstance != null && (mockUpForSingleInstance = this.mockedToMockupInstances.get(mockedInstance)) != null) {
            return mockUpForSingleInstance;
        }
        MockUp<?> startupMock = this.startupMocks.get(mockUpClassDesc);
        if (startupMock != null) {
            return startupMock;
        }
        Class mockUpClass = ClassLoad.loadByInternalName(mockUpClassDesc);
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        Class<Void> invokedInstance = mockedInstance;
        if (mockedInstance == null) {
            invokedInstance = Void.class;
        } else if (mockUpInstances.hasMockUpsForSingleInstances()) {
            return null;
        }
        try {
            INVOKED_INSTANCE_FIELD.set(mockUpInstances.initialMockUp, invokedInstance);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return mockUpInstances.initialMockUp;
    }

    @Nullable
    public MockUpInstances findPreviouslyAppliedMockUps(@Nonnull MockUp<?> newMockUp) {
        Class<?> mockUpClass = newMockUp.getClass();
        MockUpInstances mockUpInstances = this.mockupClassesToMockupInstances.get(mockUpClass);
        if (mockUpInstances != null && mockUpInstances.hasMockupsForSingleInstances) {
            this.mockStates.copyMockStates(mockUpInstances.initialMockUp, newMockUp);
        }
        return mockUpInstances;
    }

    private void discardMockupInstances(@Nonnull Map<Object, MockUp<?>> previousMockInstances) {
        if (!previousMockInstances.isEmpty()) {
            this.mockedToMockupInstances.entrySet().retainAll(previousMockInstances.entrySet());
        } else if (!this.mockedToMockupInstances.isEmpty()) {
            this.mockedToMockupInstances.clear();
        }
    }

    private void discardMockupInstancesExceptPreviousOnes(@Nonnull Map<Class<?>, Boolean> previousMockupClasses) {
        this.updatePreviousMockups(previousMockupClasses);
        for (Map.Entry<Class<?>, MockUpInstances> mockupClassAndInstances : this.mockupClassesToMockupInstances.entrySet()) {
            Class<?> mockupClass = mockupClassAndInstances.getKey();
            if (previousMockupClasses.containsKey(mockupClass)) continue;
            MockUpInstances mockUpInstances = mockupClassAndInstances.getValue();
            mockUpInstances.notifyMockUpOfTearDown();
        }
        this.mockupClassesToMockupInstances.keySet().retainAll(previousMockupClasses.keySet());
    }

    private void updatePreviousMockups(@Nonnull Map<Class<?>, Boolean> previousMockupClasses) {
        for (Map.Entry<Class<?>, Boolean> mockupClassAndData : previousMockupClasses.entrySet()) {
            Class<?> mockupClass = mockupClassAndData.getKey();
            MockUpInstances mockUpData = this.mockupClassesToMockupInstances.get(mockupClass);
            mockUpData.hasMockupsForSingleInstances = mockupClassAndData.getValue();
        }
    }

    private void discardAllMockupInstances() {
        if (!this.mockupClassesToMockupInstances.isEmpty()) {
            for (MockUpInstances mockUpInstances : this.mockupClassesToMockupInstances.values()) {
                mockUpInstances.notifyMockUpOfTearDown();
            }
            this.mockupClassesToMockupInstances.clear();
        }
    }

    public void discardStartupMocks() {
        for (MockUp<?> startupMockup : this.startupMocks.values()) {
            MockClasses.notifyOfTearDown(startupMockup);
        }
    }

    static {
        try {
            INVOKED_INSTANCE_FIELD = MockUp.class.getDeclaredField("invokedInstance");
            INVOKED_INSTANCE_FIELD.setAccessible(true);
            ON_TEAR_DOWN_METHOD = MockUp.class.getDeclaredMethod("onTearDown", new Class[0]);
            ON_TEAR_DOWN_METHOD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    final class SavePoint {
        @Nonnull
        private final Map<Object, MockUp<?>> previousMockInstances;
        @Nonnull
        private final Map<Class<?>, Boolean> previousMockupClasses;

        SavePoint() {
            this.previousMockInstances = new IdentityHashMap(MockClasses.this.mockedToMockupInstances);
            this.previousMockupClasses = new IdentityHashMap();
            for (Map.Entry mockUpClassAndData : MockClasses.this.mockupClassesToMockupInstances.entrySet()) {
                Class mockUpClass = (Class)mockUpClassAndData.getKey();
                MockUpInstances mockUpData = (MockUpInstances)mockUpClassAndData.getValue();
                this.previousMockupClasses.put(mockUpClass, mockUpData.hasMockupsForSingleInstances);
            }
        }

        void rollback() {
            MockClasses.this.discardMockupInstances(this.previousMockInstances);
            if (!this.previousMockupClasses.isEmpty()) {
                MockClasses.this.discardMockupInstancesExceptPreviousOnes(this.previousMockupClasses);
            } else {
                MockClasses.this.discardAllMockupInstances();
            }
        }
    }

    public static final class MockUpInstances {
        @Nonnull
        public final MockUp<?> initialMockUp;
        boolean hasMockupsForSingleInstances;

        MockUpInstances(@Nonnull MockUp<?> initialMockUp) {
            this.initialMockUp = initialMockUp;
            this.hasMockupsForSingleInstances = false;
        }

        public boolean hasMockUpsForSingleInstances() {
            return this.hasMockupsForSingleInstances;
        }

        void notifyMockUpOfTearDown() {
            MockClasses.notifyOfTearDown(this.initialMockUp);
        }
    }
}

