/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GenericTypeReflection {
    @Nonnull
    private final Map<String, Type> typeParametersToTypeArguments = new HashMap<String, Type>(4);
    @Nonnull
    private final Map<String, String> typeParametersToTypeArgumentNames;
    @Nonnull
    private final Class<?> ownerType;
    private final boolean withSignatures;

    public GenericTypeReflection(@Nonnull Class<?> ownerClass, @Nullable Type genericType) {
        this(ownerClass, genericType, true);
    }

    public GenericTypeReflection(@Nonnull Class<?> ownerClass, @Nullable Type genericType, boolean withSignatures) {
        this.typeParametersToTypeArgumentNames = withSignatures ? new HashMap(4) : Collections.emptyMap();
        this.ownerType = ownerClass;
        this.withSignatures = withSignatures;
        this.discoverTypeMappings(ownerClass, genericType);
    }

    private void discoverTypeMappings(@Nonnull Class<?> rawType, @Nullable Type genericType) {
        if (genericType instanceof ParameterizedType) {
            this.addMappingsFromTypeParametersToTypeArguments(rawType, (ParameterizedType)genericType);
        }
        this.addGenericTypeMappingsForSuperTypes(rawType);
    }

    private void addGenericTypeMappingsForSuperTypes(@Nonnull Class<?> rawType) {
        Type superType = rawType;
        while (superType instanceof Class && superType != Object.class) {
            Class<?> superClass = superType;
            if ((superType = superClass.getGenericSuperclass()) != null && superType != Object.class) {
                superType = superClass = this.addGenericTypeMappingsIfParameterized(superType);
            }
            this.addGenericTypeMappingsForInterfaces(superClass);
        }
    }

    @Nonnull
    private Class<?> addGenericTypeMappingsIfParameterized(@Nonnull Type superType) {
        if (superType instanceof ParameterizedType) {
            ParameterizedType genericSuperType = (ParameterizedType)superType;
            Class rawType = (Class)genericSuperType.getRawType();
            this.addMappingsFromTypeParametersToTypeArguments(rawType, genericSuperType);
            return rawType;
        }
        return (Class)superType;
    }

    private void addGenericTypeMappingsForInterfaces(@Nonnull Class<?> classOrInterface) {
        for (Type implementedInterface : classOrInterface.getGenericInterfaces()) {
            Class<?> implementedType = this.addGenericTypeMappingsIfParameterized(implementedInterface);
            this.addGenericTypeMappingsForInterfaces(implementedType);
        }
    }

    private void addMappingsFromTypeParametersToTypeArguments(@Nonnull Class<?> rawType, @Nonnull ParameterizedType genericType) {
        String ownerTypeDesc = GenericTypeReflection.getOwnerClassDesc(rawType);
        TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
        Type[] typeArguments = genericType.getActualTypeArguments();
        int n = typeParameters.length;
        for (int i = 0; i < n; ++i) {
            TypeVariable<Class<?>> typeParam = typeParameters[i];
            String typeVarName = typeParam.getName();
            if (this.typeParametersToTypeArguments.containsKey(ownerTypeDesc + ':' + typeVarName)) continue;
            Type typeArg = typeArguments[i];
            if (typeArg instanceof Class) {
                this.addMappingForClassType(ownerTypeDesc, typeVarName, typeArg);
                continue;
            }
            if (typeArg instanceof TypeVariable) {
                this.addMappingForTypeVariable(ownerTypeDesc, typeVarName, typeArg);
                continue;
            }
            if (typeArg instanceof ParameterizedType) {
                this.addMappingForParameterizedType(ownerTypeDesc, typeVarName, typeArg);
                continue;
            }
            if (typeArg instanceof GenericArrayType) {
                this.addMappingForArrayType(ownerTypeDesc, typeVarName, typeArg);
                continue;
            }
            this.addMappingForFirstTypeBound(ownerTypeDesc, typeParam);
        }
        Type outerType = genericType.getOwnerType();
        if (outerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOuterType = (ParameterizedType)outerType;
            Class rawOuterType = (Class)parameterizedOuterType.getRawType();
            this.addMappingsFromTypeParametersToTypeArguments(rawOuterType, parameterizedOuterType);
        }
    }

    private void addMappingForClassType(@Nonnull String ownerTypeDesc, @Nonnull String typeName, @Nonnull Type typeArg) {
        String mappedTypeArgName = null;
        if (this.withSignatures) {
            Class classArg = (Class)typeArg;
            String ownerClassDesc = GenericTypeReflection.getOwnerClassDesc(classArg);
            mappedTypeArgName = classArg.isArray() ? ownerClassDesc : 'L' + ownerClassDesc;
        }
        this.addTypeMapping(ownerTypeDesc, typeName, typeArg, mappedTypeArgName);
    }

    private void addMappingForTypeVariable(@Nonnull String ownerTypeDesc, @Nonnull String typeName, @Nonnull Type typeArg) {
        String mappedTypeArgName = null;
        if (this.withSignatures) {
            TypeVariable typeVar = (TypeVariable)typeArg;
            String ownerClassDesc = this.getOwnerClassDesc(typeVar);
            String intermediateTypeArg = ownerClassDesc + ":T" + typeVar.getName();
            mappedTypeArgName = this.typeParametersToTypeArgumentNames.get(intermediateTypeArg);
        }
        this.addTypeMapping(ownerTypeDesc, typeName, typeArg, mappedTypeArgName);
    }

    private void addMappingForParameterizedType(@Nonnull String ownerTypeDesc, @Nonnull String typeName, @Nonnull Type typeArg) {
        String mappedTypeArgName = this.getMappedTypeArgName(typeArg);
        this.addTypeMapping(ownerTypeDesc, typeName, typeArg, mappedTypeArgName);
    }

    @Nullable
    private String getMappedTypeArgName(@Nonnull Type typeArg) {
        if (this.withSignatures) {
            Class<?> classType = this.getClassType(typeArg);
            return 'L' + GenericTypeReflection.getOwnerClassDesc(classType);
        }
        return null;
    }

    private void addMappingForArrayType(@Nonnull String ownerTypeDesc, @Nonnull String typeName, @Nonnull Type typeArg) {
        String mappedTypeArgName = null;
        if (this.withSignatures) {
            mappedTypeArgName = this.getMappedTypeArgName((GenericArrayType)typeArg);
        }
        this.addTypeMapping(ownerTypeDesc, typeName, typeArg, mappedTypeArgName);
    }

    private void addMappingForFirstTypeBound(@Nonnull String ownerTypeDesc, @Nonnull TypeVariable<?> typeParam) {
        Type typeArg = typeParam.getBounds()[0];
        String mappedTypeArgName = this.getMappedTypeArgName(typeArg);
        this.addTypeMapping(ownerTypeDesc, typeParam.getName(), typeArg, mappedTypeArgName);
    }

    @Nonnull
    private static String getOwnerClassDesc(@Nonnull Class<?> rawType) {
        return rawType.getName().replace('.', '/');
    }

    @Nonnull
    private Class<?> getClassType(@Nonnull Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            String typeVarKey = this.getTypeVariableKey(typeVar);
            Type typeArg = this.typeParametersToTypeArguments.get(typeVarKey);
            if (typeArg == null) {
                throw new IllegalArgumentException("Unable to resolve type variable \"" + typeVar.getName() + '\"');
            }
            return this.getClassType(typeArg);
        }
        return (Class)type;
    }

    @Nonnull
    private String getMappedTypeArgName(@Nonnull GenericArrayType arrayType) {
        Type componentType;
        StringBuilder argName = new StringBuilder(20);
        argName.append('[');
        while ((componentType = arrayType.getGenericComponentType()) instanceof GenericArrayType) {
            argName.append('[');
            arrayType = (GenericArrayType)componentType;
        }
        Class<?> classType = this.getClassType(componentType);
        argName.append('L').append(GenericTypeReflection.getOwnerClassDesc(classType));
        return argName.toString();
    }

    private void addTypeMapping(@Nonnull String ownerTypeDesc, @Nonnull String typeVarName, @Nonnull Type mappedTypeArg, @Nullable String mappedTypeArgName) {
        this.typeParametersToTypeArguments.put(ownerTypeDesc + ':' + typeVarName, mappedTypeArg);
        if (mappedTypeArgName != null) {
            this.addTypeMapping(ownerTypeDesc, typeVarName, mappedTypeArgName);
        }
    }

    private void addTypeMapping(@Nonnull String ownerTypeDesc, @Nonnull String typeVarName, @Nonnull String mappedTypeArgName) {
        String typeMappingKey = ownerTypeDesc + ":T" + typeVarName;
        this.typeParametersToTypeArgumentNames.put(typeMappingKey, mappedTypeArgName);
    }

    @Nonnull
    public GenericSignature parseSignature(@Nonnull String genericSignature) {
        return new GenericSignature(genericSignature);
    }

    @Nonnull
    public String resolveReturnType(@Nonnull String ownerTypeDesc, @Nonnull String genericSignature) {
        this.addTypeArgumentsIfAvailable(ownerTypeDesc, genericSignature);
        int p = genericSignature.lastIndexOf(41) + 1;
        int q = genericSignature.length();
        String returnType = genericSignature.substring(p, q);
        String resolvedReturnType = this.replaceTypeParametersWithActualTypes(ownerTypeDesc, returnType);
        StringBuilder finalSignature = new StringBuilder(genericSignature);
        finalSignature.replace(p, q, resolvedReturnType);
        return finalSignature.toString();
    }

    private void addTypeArgumentsIfAvailable(@Nonnull String ownerTypeDesc, @Nonnull String signature) {
        int firstParen = signature.indexOf(40);
        if (firstParen == 0) {
            return;
        }
        int p = 1;
        boolean lastMappingFound = false;
        while (!lastMappingFound) {
            int r;
            int q = signature.indexOf(58, p);
            String typeVar = signature.substring(p, q);
            if (signature.charAt(++q) == ':') {
                ++q;
            }
            if ((r = signature.indexOf(58, q)) < 0) {
                r = firstParen - 2;
                lastMappingFound = true;
            } else {
                r = signature.lastIndexOf(59, r);
                p = r + 1;
            }
            String typeArg = signature.substring(q, r);
            this.addTypeMapping(ownerTypeDesc, typeVar, typeArg);
        }
    }

    @Nonnull
    private String replaceTypeParametersWithActualTypes(@Nonnull String ownerTypeDesc, @Nonnull String typeDesc) {
        if (typeDesc.charAt(0) == 'T' && !this.typeParametersToTypeArgumentNames.isEmpty()) {
            String typeParameter = typeDesc.substring(0, typeDesc.length() - 1);
            String typeArg = this.typeParametersToTypeArgumentNames.get(ownerTypeDesc + ':' + typeParameter);
            return typeArg == null ? typeDesc : typeArg + ';';
        }
        int p = typeDesc.indexOf(60);
        if (p < 0) {
            return typeDesc;
        }
        String resolvedTypeDesc = typeDesc;
        for (Map.Entry<String, String> paramAndArg : this.typeParametersToTypeArgumentNames.entrySet()) {
            String typeMappingKey = paramAndArg.getKey();
            String typeParam = typeMappingKey.substring(typeMappingKey.indexOf(58) + 1) + ';';
            String typeArg = paramAndArg.getValue() + ';';
            resolvedTypeDesc = resolvedTypeDesc.replace(typeParam, typeArg);
        }
        return resolvedTypeDesc;
    }

    @Nonnull
    public Type resolveTypeVariable(@Nonnull TypeVariable<?> typeVariable) {
        String typeVarKey = this.getTypeVariableKey(typeVariable);
        Type typeArgument = this.typeParametersToTypeArguments.get(typeVarKey);
        if (typeArgument == null) {
            typeArgument = typeVariable.getBounds()[0];
        }
        if (typeArgument instanceof TypeVariable) {
            typeArgument = this.resolveTypeVariable((TypeVariable)typeArgument);
        }
        return typeArgument;
    }

    @Nonnull
    private String getTypeVariableKey(@Nonnull TypeVariable<?> typeVariable) {
        String ownerClassDesc = this.getOwnerClassDesc(typeVariable);
        return ownerClassDesc + ':' + typeVariable.getName();
    }

    @Nonnull
    private String getOwnerClassDesc(@Nonnull TypeVariable<?> typeVariable) {
        Object owner = typeVariable.getGenericDeclaration();
        Class<?> ownerClass = owner instanceof Member ? ((Member)owner).getDeclaringClass() : (Class<?>)owner;
        return GenericTypeReflection.getOwnerClassDesc(ownerClass);
    }

    @Nonnull
    public String resolveReturnType(@Nonnull String genericSignature) {
        String resolvedSignature;
        int p = genericSignature.lastIndexOf(41) + 1;
        if (this.typeParametersToTypeArgumentNames.isEmpty() && genericSignature.charAt(0) != '<') {
            return genericSignature.substring(p);
        }
        int q = genericSignature.length();
        String returnType = genericSignature.substring(p, q);
        String resolvedReturnType = this.resolveReturnType(this.ownerType, returnType);
        if (resolvedReturnType == null) {
            resolvedSignature = returnType;
        } else {
            if (resolvedReturnType.charAt(0) == '[') {
                return resolvedReturnType;
            }
            StringBuilder finalSignature = new StringBuilder(genericSignature);
            finalSignature.replace(p, q, resolvedReturnType);
            resolvedSignature = finalSignature.toString();
        }
        p = resolvedSignature.indexOf(41);
        return resolvedSignature.substring(p + 1);
    }

    @Nullable
    private String resolveReturnType(@Nonnull Class<?> ownerType, @Nonnull String genericReturnType) {
        do {
            String ownerTypeDesc;
            String resolvedReturnType;
            if (!(resolvedReturnType = this.replaceTypeParametersWithActualTypes(ownerTypeDesc = GenericTypeReflection.getOwnerClassDesc(ownerType), genericReturnType)).equals(genericReturnType)) {
                return resolvedReturnType;
            }
            resolvedReturnType = this.resolveReturnTypeForAbstractMethod(ownerType, genericReturnType);
            if (resolvedReturnType == null) continue;
            return resolvedReturnType;
        } while ((ownerType = ownerType.getSuperclass()) != null && ownerType != Object.class);
        return null;
    }

    @Nullable
    private String resolveReturnTypeForAbstractMethod(@Nonnull Class<?> ownerType, @Nonnull String genericReturnType) {
        String resolvedReturnType = null;
        for (Class<?> superInterface : ownerType.getInterfaces()) {
            resolvedReturnType = this.resolveReturnType(superInterface, genericReturnType);
            if (resolvedReturnType == null) continue;
            return resolvedReturnType;
        }
        Class<?> outerClass = ownerType.getEnclosingClass();
        if (outerClass != null) {
            resolvedReturnType = this.resolveReturnType(outerClass, genericReturnType);
        }
        return resolvedReturnType;
    }

    public boolean areMatchingTypes(@Nonnull Type declarationType, @Nonnull Type realizationType) {
        if (declarationType.equals(realizationType)) {
            return true;
        }
        if (declarationType instanceof Class) {
            if (realizationType instanceof Class) {
                return ((Class)declarationType).isAssignableFrom((Class)realizationType);
            }
        } else if (declarationType instanceof TypeVariable) {
            if (realizationType instanceof TypeVariable) {
                return false;
            }
            if (this.areMatchingTypes((TypeVariable)declarationType, realizationType)) {
                return true;
            }
        } else if (declarationType instanceof ParameterizedType) {
            ParameterizedType parameterizedDeclarationType = (ParameterizedType)declarationType;
            ParameterizedType parameterizedRealizationType = this.getParameterizedType(realizationType);
            if (parameterizedRealizationType != null) {
                return this.areMatchingTypes(parameterizedDeclarationType, parameterizedRealizationType);
            }
        }
        return false;
    }

    @Nullable
    private ParameterizedType getParameterizedType(@Nonnull Type realizationType) {
        if (realizationType instanceof ParameterizedType) {
            return (ParameterizedType)realizationType;
        }
        if (realizationType instanceof Class) {
            return this.findRealizationSupertype((Class)realizationType);
        }
        return null;
    }

    @Nullable
    private ParameterizedType findRealizationSupertype(@Nonnull Class<?> realizationType) {
        Type realizationSuperclass = realizationType.getGenericSuperclass();
        ParameterizedType parameterizedRealizationType = null;
        if (realizationSuperclass instanceof ParameterizedType) {
            parameterizedRealizationType = (ParameterizedType)realizationSuperclass;
        } else {
            for (Type realizationSupertype : realizationType.getGenericInterfaces()) {
                if (!(realizationSupertype instanceof ParameterizedType)) continue;
                parameterizedRealizationType = (ParameterizedType)realizationSupertype;
                break;
            }
        }
        return parameterizedRealizationType;
    }

    private boolean areMatchingTypes(@Nonnull TypeVariable<?> declarationType, @Nonnull Type realizationType) {
        String typeVarKey = this.getTypeVariableKey(declarationType);
        Type resolvedType = this.typeParametersToTypeArguments.get(typeVarKey);
        return resolvedType != null && (resolvedType.equals(realizationType) || this.typeSatisfiesResolvedTypeVariable(resolvedType, realizationType));
    }

    private boolean areMatchingTypes(@Nonnull ParameterizedType declarationType, @Nonnull ParameterizedType realizationType) {
        return declarationType.getRawType().equals(realizationType.getRawType()) && this.haveMatchingActualTypeArguments(declarationType, realizationType);
    }

    private boolean haveMatchingActualTypeArguments(@Nonnull ParameterizedType declarationType, @Nonnull ParameterizedType realizationType) {
        Type[] declaredTypeArguments = declarationType.getActualTypeArguments();
        Type[] concreteTypeArguments = realizationType.getActualTypeArguments();
        int n = declaredTypeArguments.length;
        for (int i = 0; i < n; ++i) {
            Type declaredTypeArg = declaredTypeArguments[i];
            Type concreteTypeArg = concreteTypeArguments[i];
            if (declaredTypeArg instanceof TypeVariable ? this.areMatchingTypeArguments((TypeVariable)declaredTypeArg, concreteTypeArg) : this.areMatchingTypes(declaredTypeArg, concreteTypeArg)) continue;
            return false;
        }
        return true;
    }

    private boolean areMatchingTypeArguments(@Nonnull TypeVariable<?> declaredType, @Nonnull Type concreteType) {
        String typeVarKey = this.getTypeVariableKey(declaredType);
        Type resolvedType = this.typeParametersToTypeArguments.get(typeVarKey);
        if (resolvedType != null) {
            if (resolvedType.equals(concreteType)) {
                return true;
            }
            if (concreteType instanceof Class && this.typeSatisfiesResolvedTypeVariable(resolvedType, (Class)concreteType)) {
                return true;
            }
            if (concreteType instanceof WildcardType && this.typeSatisfiesUpperBounds(resolvedType, ((WildcardType)concreteType).getUpperBounds())) {
                return true;
            }
        } else if (this.typeSatisfiesUpperBounds(concreteType, declaredType.getBounds())) {
            return true;
        }
        return false;
    }

    private boolean typeSatisfiesResolvedTypeVariable(@Nonnull Type resolvedType, @Nonnull Type realizationType) {
        Class<?> realizationClass = this.getClassType(realizationType);
        return this.typeSatisfiesResolvedTypeVariable(resolvedType, realizationClass);
    }

    private boolean typeSatisfiesResolvedTypeVariable(@Nonnull Type resolvedType, @Nonnull Class<?> realizationType) {
        Class<?> resolvedClass = this.getClassType(resolvedType);
        return resolvedClass.isAssignableFrom(realizationType);
    }

    private boolean typeSatisfiesUpperBounds(@Nonnull Type type, @Nonnull Type[] upperBounds) {
        Class<?> classType = this.getClassType(type);
        for (Type upperBound : upperBounds) {
            Class<?> classBound = this.getClassType(upperBound);
            if (classBound.isAssignableFrom(classType)) continue;
            return false;
        }
        return true;
    }

    public final class GenericSignature {
        private final List<String> parameters;
        private final String parameterTypeDescs;
        private final int lengthOfParameterTypeDescs;
        private int currentPos;

        GenericSignature(String signature) {
            int p = signature.indexOf(40);
            int q = signature.lastIndexOf(41);
            this.parameterTypeDescs = signature.substring(p + 1, q);
            this.lengthOfParameterTypeDescs = this.parameterTypeDescs.length();
            this.parameters = new ArrayList<String>();
            this.addTypeDescsToList();
        }

        private void addTypeDescsToList() {
            while (this.currentPos < this.lengthOfParameterTypeDescs) {
                this.addNextParameter();
            }
        }

        private void addNextParameter() {
            int endPos;
            int startPos = this.currentPos;
            char c = this.parameterTypeDescs.charAt(startPos);
            if (c == 'T') {
                this.currentPos = endPos = this.parameterTypeDescs.indexOf(59, startPos);
            } else if (c == 'L') {
                endPos = this.advanceToEndOfTypeDesc();
            } else if (c == '[') {
                char elemTypeStart = this.firstCharacterOfArrayElementType();
                if (elemTypeStart == 'T') {
                    this.currentPos = endPos = this.parameterTypeDescs.indexOf(59, startPos);
                } else {
                    endPos = elemTypeStart == 'L' ? this.advanceToEndOfTypeDesc() : this.currentPos + 1;
                }
            } else {
                endPos = this.currentPos + 1;
            }
            ++this.currentPos;
            String parameter = this.parameterTypeDescs.substring(startPos, endPos);
            this.parameters.add(parameter);
        }

        private int advanceToEndOfTypeDesc() {
            char c = '\u0000';
            do {
                ++this.currentPos;
            } while (this.currentPos != this.lengthOfParameterTypeDescs && (c = this.parameterTypeDescs.charAt(this.currentPos)) != ';' && c != '<');
            int endPos = this.currentPos++;
            if (c == '<') {
                this.advancePastTypeArguments();
            }
            return endPos;
        }

        private char firstCharacterOfArrayElementType() {
            char c;
            do {
                ++this.currentPos;
            } while ((c = this.parameterTypeDescs.charAt(this.currentPos)) == '[');
            return c;
        }

        private void advancePastTypeArguments() {
            int angleBracketDepth = 1;
            do {
                ++this.currentPos;
                char c = this.parameterTypeDescs.charAt(this.currentPos);
                if (c == '>') {
                    --angleBracketDepth;
                    continue;
                }
                if (c != '<') continue;
                ++angleBracketDepth;
            } while (angleBracketDepth > 0);
        }

        public boolean satisfiesGenericSignature(@Nonnull String otherSignature) {
            GenericSignature other = new GenericSignature(otherSignature);
            return this.areMatchingSignatures(other);
        }

        private boolean areMatchingSignatures(@Nonnull GenericSignature other) {
            int n = this.parameters.size();
            if (n != other.parameters.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                String p2;
                String p1 = other.parameters.get(i);
                if (this.areParametersOfSameType(p1, p2 = this.parameters.get(i))) continue;
                return false;
            }
            return true;
        }

        private boolean areParametersOfSameType(@Nonnull String param1, @Nonnull String param2) {
            char c;
            if (param1.equals(param2)) {
                return true;
            }
            int i = -1;
            while ((c = param1.charAt(++i)) == '[') {
            }
            if (c != 'T') {
                return false;
            }
            String typeVarName1 = param1.substring(i);
            String typeVarName2 = param2.substring(i);
            String typeArg1 = null;
            for (Map.Entry typeParamAndArgName : GenericTypeReflection.this.typeParametersToTypeArgumentNames.entrySet()) {
                String typeMappingKey = (String)typeParamAndArgName.getKey();
                String typeVarName = typeMappingKey.substring(typeMappingKey.indexOf(58) + 1);
                if (!typeVarName.equals(typeVarName1)) continue;
                typeArg1 = (String)typeParamAndArgName.getValue();
                break;
            }
            return typeVarName2.equals(typeArg1);
        }

        public boolean satisfiesSignature(@Nonnull String otherSignature) {
            GenericSignature other = new GenericSignature(otherSignature);
            return other.areMatchingSignatures(this);
        }
    }
}

