/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.ParameterReflection;
import mockit.internal.reflection.ThrowOfCheckedException;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;
import sun.reflect.ReflectionFactory;

public final class ConstructorReflection {
    private static final Constructor<?> OBJECT_CONSTRUCTOR;
    private static final ReflectionFactory REFLECTION_FACTORY;

    private ConstructorReflection() {
    }

    @Nonnull
    public static <T> T newInstance(@Nonnull Class<T> aClass, @Nonnull Class<?>[] parameterTypes, Object ... initArgs) {
        if (initArgs == null) {
            throw ParameterReflection.invalidArguments();
        }
        Constructor<T> constructor = ConstructorReflection.findSpecifiedConstructor(aClass, parameterTypes);
        return ConstructorReflection.invoke(constructor, initArgs);
    }

    @Nonnull
    static <T> Constructor<T> findSpecifiedConstructor(@Nonnull Class<?> theClass, @Nonnull Class<?>[] paramTypes) {
        for (Constructor<?> declaredConstructor : theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParameterTypes = declaredConstructor.getParameterTypes();
            int firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParameterTypes, paramTypes);
            if (firstRealParameter < 0 || !ParameterReflection.matchesParameterTypes(declaredParameterTypes, paramTypes, firstRealParameter)) continue;
            return declaredConstructor;
        }
        String paramTypesDesc = ParameterReflection.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified constructor not found: " + theClass.getSimpleName() + paramTypesDesc);
    }

    @Nonnull
    public static <T> T invoke(@Nonnull Constructor<T> constructor, Object ... initArgs) {
        Utilities.ensureThatMemberIsAccessible(constructor);
        try {
            return constructor.newInstance(initArgs);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ThrowOfCheckedException.doThrow((Exception)cause);
            throw new IllegalStateException("Should never get here", cause);
        }
    }

    @Nonnull
    public static <T> T newInstance(@Nonnull String className, @Nonnull Class<?>[] parameterTypes, Object ... initArgs) {
        Class theClass = ClassLoad.loadClass(className);
        return ConstructorReflection.newInstance(theClass, parameterTypes, initArgs);
    }

    @Nonnull
    public static <T> T newInstance(@Nonnull String className, Object ... nonNullArgs) {
        if (nonNullArgs == null) {
            throw ParameterReflection.invalidArguments();
        }
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(nonNullArgs);
        Class theClass = ClassLoad.loadClass(className);
        Constructor<T> constructor = ConstructorReflection.findCompatibleConstructor(theClass, argTypes);
        return ConstructorReflection.invoke(constructor, nonNullArgs);
    }

    @Nonnull
    private static <T> Constructor<T> findCompatibleConstructor(@Nonnull Class<?> theClass, @Nonnull Class<?>[] argTypes) {
        Constructor<?>[] declaredConstructors;
        Constructor<?> found = null;
        Class<?>[] foundParameters = null;
        for (Constructor<?> declaredConstructor : declaredConstructors = theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParamTypes = declaredConstructor.getParameterTypes();
            int firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParamTypes, argTypes);
            if (firstRealParameter < 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes, firstRealParameter) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes, firstRealParameter) || found != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParameters)) continue;
            found = declaredConstructor;
            foundParameters = declaredParamTypes;
        }
        if (found != null) {
            return found;
        }
        Class<?> declaringClass = theClass.getDeclaringClass();
        Class<?>[] paramTypes = declaredConstructors[0].getParameterTypes();
        if (paramTypes.length > argTypes.length && paramTypes[0] == declaringClass) {
            throw new IllegalArgumentException("Invalid instantiation of inner class; use newInnerInstance instead");
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible constructor found: " + theClass.getSimpleName() + argTypesDesc);
    }

    @Nonnull
    public static <T> T newInstance(@Nonnull Class<? extends T> aClass, Object ... nonNullArgs) {
        if (nonNullArgs == null) {
            throw ParameterReflection.invalidArguments();
        }
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(nonNullArgs);
        Constructor<T> constructor = ConstructorReflection.findCompatibleConstructor(aClass, argTypes);
        return ConstructorReflection.invoke(constructor, nonNullArgs);
    }

    @Nonnull
    public static <T> T newInstanceUsingDefaultConstructor(@Nonnull Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException ignore) {
            return ConstructorReflection.newInstance(aClass, (Object[])ParameterReflection.NO_PARAMETERS);
        }
    }

    @Nullable
    public static <T> T newInstanceUsingDefaultConstructorIfAvailable(@Nonnull Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException ignore) {
            return null;
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
    }

    @Nonnull
    public static <T> T newInstanceUsingPublicDefaultConstructor(@Nonnull Class<T> aClass) {
        Constructor<T> publicConstructor;
        try {
            publicConstructor = aClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return ConstructorReflection.invoke(publicConstructor, new Object[0]);
    }

    @Nullable
    public static <T> T newInstanceUsingPublicConstructorIfAvailable(@Nonnull Class<T> aClass, @Nonnull Class<?>[] parameterTypes, Object ... initArgs) {
        Constructor<T> publicConstructor;
        try {
            publicConstructor = aClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        return ConstructorReflection.invoke(publicConstructor, initArgs);
    }

    @Nonnull
    public static <T> T newInnerInstance(@Nonnull Class<? extends T> innerClass, @Nonnull Object outerInstance, Object ... nonNullArgs) {
        if (nonNullArgs == null) {
            throw ParameterReflection.invalidArguments();
        }
        if (Modifier.isStatic(innerClass.getModifiers())) {
            throw new IllegalArgumentException(innerClass.getSimpleName() + " is not an inner class");
        }
        Object[] initArgs = ParameterReflection.argumentsWithExtraFirstValue(nonNullArgs, outerInstance);
        return ConstructorReflection.newInstance(innerClass, initArgs);
    }

    @Nonnull
    public static <T> T newInnerInstance(@Nonnull String innerClassName, @Nonnull Object outerInstance, Object ... nonNullArgs) {
        Class<?> outerClass = outerInstance.getClass();
        ClassLoader loader = outerClass.getClassLoader();
        String className = outerClass.getName() + '$' + innerClassName;
        Class innerClass = ClassLoad.loadFromLoader(loader, className);
        return ConstructorReflection.newInnerInstance(innerClass, outerInstance, nonNullArgs);
    }

    @Nonnull
    public static <T> T newUninitializedInstance(@Nonnull Class<T> aClass) {
        try {
            Constructor<?> fakeConstructor = REFLECTION_FACTORY.newConstructorForSerialization(aClass, OBJECT_CONSTRUCTOR);
            if (fakeConstructor == null) {
                return null;
            }
            Object newInstance = fakeConstructor.newInstance(new Object[0]);
            return (T)newInstance;
        }
        catch (NoClassDefFoundError e) {
            StackTrace.filterStackTrace(e);
            e.printStackTrace();
            throw e;
        }
        catch (ExceptionInInitializerError e) {
            StackTrace.filterStackTrace(e);
            e.printStackTrace();
            throw e;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    static {
        try {
            OBJECT_CONSTRUCTOR = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    }
}

