/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.mockups.MockState;
import mockit.internal.util.ClassLoad;

public final class MockStates {
    private static final Pattern SPACE = Pattern.compile(" ");
    @Nonnull
    private final Map<Object, List<MockState>> mockUpsToMockStates;
    @Nonnull
    private final Map<Object, List<MockState>> startupMockUpsToMockStates = new IdentityHashMap<Object, List<MockState>>(2);

    public MockStates() {
        this.mockUpsToMockStates = new IdentityHashMap<Object, List<MockState>>(8);
    }

    void addStartupMockUpAndItsMockStates(@Nonnull Object mockUp, @Nonnull List<MockState> mockStates) {
        this.startupMockUpsToMockStates.put(mockUp, mockStates);
    }

    void addMockUpAndItsMockStates(@Nonnull Object mockUp, @Nonnull List<MockState> mockStates) {
        this.mockUpsToMockStates.put(mockUp, mockStates);
    }

    public void copyMockStates(@Nonnull Object previousMockUp, @Nonnull Object newMockUp) {
        List<MockState> mockStates = this.mockUpsToMockStates.get(previousMockUp);
        if (mockStates != null) {
            ArrayList<MockState> copiedMockStates = new ArrayList<MockState>(mockStates.size());
            for (MockState mockState : mockStates) {
                copiedMockStates.add(new MockState(mockState));
            }
            this.mockUpsToMockStates.put(newMockUp, copiedMockStates);
        }
    }

    public void removeClassState(@Nonnull Class<?> redefinedClass, @Nullable String internalNameForOneOrMoreMockClasses) {
        this.removeMockStates(redefinedClass);
        if (internalNameForOneOrMoreMockClasses != null) {
            if (internalNameForOneOrMoreMockClasses.indexOf(32) < 0) {
                this.removeMockStates(internalNameForOneOrMoreMockClasses);
            } else {
                String[] mockClassesInternalNames;
                for (String mockClassInternalName : mockClassesInternalNames = SPACE.split(internalNameForOneOrMoreMockClasses)) {
                    this.removeMockStates(mockClassInternalName);
                }
            }
        }
    }

    private void removeMockStates(@Nonnull Class<?> redefinedClass) {
        Iterator<List<MockState>> itr = this.mockUpsToMockStates.values().iterator();
        while (itr.hasNext()) {
            List<MockState> mockStates = itr.next();
            MockState mockState = mockStates.get(0);
            if (mockState.getRealClass() != redefinedClass) continue;
            mockStates.clear();
            itr.remove();
        }
    }

    private void removeMockStates(@Nonnull String mockClassInternalName) {
        Class mockUpClass = ClassLoad.loadClass(mockClassInternalName.replace('/', '.'));
        Iterator<Map.Entry<Object, List<MockState>>> itr = this.mockUpsToMockStates.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, List<MockState>> mockUpAndMockStates = itr.next();
            Object mockUp = mockUpAndMockStates.getKey();
            if (mockUp.getClass() != mockUpClass) continue;
            itr.remove();
        }
    }

    public boolean updateMockState(@Nonnull Object mockUp, int mockStateIndex) {
        MockState mockState = this.getMockState(mockUp, mockStateIndex);
        return mockState.update();
    }

    @Nonnull
    MockState getMockState(@Nonnull Object mockUp, int mockStateIndex) {
        List<MockState> mockStates = this.startupMockUpsToMockStates.get(mockUp);
        if (mockStates == null) {
            mockStates = this.mockUpsToMockStates.get(mockUp);
        }
        MockState mockState = mockStates.get(mockStateIndex);
        assert (mockState != null);
        return mockState;
    }
}

