/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.full;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.enterprise.context.Conversation;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.CommonDataSource;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.injection.full.JPADependencies;
import mockit.internal.injection.full.ServletDependencies;
import mockit.internal.injection.full.TestConversation;
import mockit.internal.injection.full.TestDataSource;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.util.Utilities;

public final class FullInjection {
    private static final int INVALID_TYPES = 25600;
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    private final Class<?> testedClass;
    @Nonnull
    private final String testedName;
    @Nullable
    private final ServletDependencies servletDependencies;
    @Nullable
    private final JPADependencies jpaDependencies;
    @Nullable
    private Class<?> dependencyClass;
    @Nullable
    private InjectionProvider injectionProvider;

    public FullInjection(@Nonnull InjectionState injectionState, @Nonnull Class<?> testedClass, @Nonnull String testedName) {
        this.injectionState = injectionState;
        this.testedClass = testedClass;
        this.testedName = testedName;
        this.servletDependencies = InjectionPoint.SERVLET_CLASS == null ? null : new ServletDependencies(injectionState);
        this.jpaDependencies = InjectionPoint.PERSISTENCE_UNIT_CLASS == null ? null : new JPADependencies(injectionState);
    }

    @Nullable
    public Object reuseInstance(@Nonnull TestedClass testedClass, @Nonnull InjectionProvider injectionProvider, @Nullable String qualifiedName) {
        this.injectionProvider = injectionProvider;
        InjectionPoint injectionPoint = this.getInjectionPoint(testedClass.reflection, injectionProvider, qualifiedName);
        Object dependency = this.injectionState.getInstantiatedDependency(testedClass, injectionPoint);
        return dependency;
    }

    @Nonnull
    private InjectionPoint getInjectionPoint(@Nonnull GenericTypeReflection reflection, @Nonnull InjectionProvider injectionProvider, @Nullable String qualifiedName) {
        Type dependencyType = injectionProvider.getDeclaredType();
        if (dependencyType instanceof TypeVariable) {
            dependencyType = reflection.resolveTypeVariable((TypeVariable)dependencyType);
            this.dependencyClass = Utilities.getClassType(dependencyType);
        } else {
            this.dependencyClass = injectionProvider.getClassOfDeclaredType();
        }
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            return new InjectionPoint(this.dependencyClass, qualifiedName, true);
        }
        if (this.jpaDependencies != null && JPADependencies.isApplicable(this.dependencyClass)) {
            for (Annotation annotation : injectionProvider.getAnnotations()) {
                InjectionPoint injectionPoint = this.jpaDependencies.getInjectionPointIfAvailable(annotation);
                if (injectionPoint == null) continue;
                return injectionPoint;
            }
        }
        return new InjectionPoint(dependencyType, injectionProvider.getName(), false);
    }

    @Nullable
    public Object createOrReuseInstance(@Nonnull Injector injector, @Nonnull InjectionProvider injectionProvider, @Nullable String qualifiedName) {
        Class<?> resolvedType;
        TestedClass testedClass = injector.testedClass;
        this.setInjectionProvider(injectionProvider);
        InjectionPoint injectionPoint = this.getInjectionPoint(testedClass.reflection, injectionProvider, qualifiedName);
        Object dependency = this.injectionState.getInstantiatedDependency(testedClass, injectionPoint);
        if (dependency != null) {
            return dependency;
        }
        Class<?> typeToInject = this.dependencyClass;
        if (typeToInject == Logger.class) {
            return Logger.getLogger(testedClass.nameOfTestedClass);
        }
        if (typeToInject == null || !FullInjection.isInstantiableType(typeToInject)) {
            return null;
        }
        if (typeToInject.isInterface() && (dependency = this.createInstanceOfSupportedInterfaceIfApplicable(testedClass, typeToInject, injectionPoint, injectionProvider)) == null && (resolvedType = this.injectionState.resolveInterface(typeToInject)) != null && !resolvedType.isInterface()) {
            typeToInject = resolvedType;
        }
        if (dependency == null) {
            dependency = this.createAndRegisterNewInstance(typeToInject, injector, injectionPoint, injectionProvider);
        }
        return dependency;
    }

    private void setInjectionProvider(@Nonnull InjectionProvider injectionProvider) {
        injectionProvider.parent = this.injectionProvider;
        this.injectionProvider = injectionProvider;
    }

    private static boolean isInstantiableType(@Nonnull Class<?> type) {
        if (type.isPrimitive() || type.isArray() || type.isAnnotation()) {
            return false;
        }
        if (!type.isInterface()) {
            int typeModifiers = type.getModifiers();
            if ((typeModifiers & 0x6400) != 0 || !Modifier.isStatic(typeModifiers) && type.isMemberClass()) {
                return false;
            }
            if (type.getClassLoader() == null) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Object createInstanceOfSupportedInterfaceIfApplicable(@Nonnull TestedClass testedClass, @Nonnull Class<?> typeToInject, @Nonnull InjectionPoint injectionPoint, @Nonnull InjectionProvider injectionProvider) {
        Object dependency = null;
        if (CommonDataSource.class.isAssignableFrom(typeToInject)) {
            dependency = this.createAndRegisterDataSource(testedClass, injectionPoint);
        } else if (InjectionPoint.INJECT_CLASS != null && typeToInject == Provider.class) {
            dependency = this.createProviderInstance(injectionProvider);
        } else if (InjectionPoint.CONVERSATION_CLASS != null && typeToInject == Conversation.class) {
            dependency = this.createAndRegisterConversationInstance();
        } else if (this.servletDependencies != null && ServletDependencies.isApplicable(typeToInject)) {
            dependency = this.servletDependencies.createAndRegisterDependency(typeToInject);
        } else if (this.jpaDependencies != null && JPADependencies.isApplicable(typeToInject)) {
            dependency = this.jpaDependencies.createAndRegisterDependency(typeToInject, injectionPoint);
        }
        return dependency;
    }

    @Nullable
    private Object createAndRegisterDataSource(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        TestDataSource dsCreation = new TestDataSource(injectionPoint);
        CommonDataSource dataSource = dsCreation.createIfDataSourceDefinitionAvailable(testedClass);
        if (dataSource != null) {
            this.injectionState.saveInstantiatedDependency(injectionPoint, dataSource);
        }
        return dataSource;
    }

    @Nonnull
    private Object createProviderInstance(@Nonnull InjectionProvider injectionProvider) {
        ParameterizedType genericType = (ParameterizedType)injectionProvider.getDeclaredType();
        final Class providedClass = (Class)genericType.getActualTypeArguments()[0];
        if (providedClass.isAnnotationPresent(Singleton.class)) {
            return new Provider<Object>(){
                private Object dependency;

                public synchronized Object get() {
                    if (this.dependency == null) {
                        this.dependency = FullInjection.this.createNewInstance(providedClass);
                    }
                    return this.dependency;
                }
            };
        }
        return new Provider<Object>(){

            public Object get() {
                Object dependency = FullInjection.this.createNewInstance(providedClass);
                return dependency;
            }
        };
    }

    @Nullable
    private Object createNewInstance(@Nonnull Class<?> dependencyClass) {
        if (dependencyClass.isInterface()) {
            return null;
        }
        if (dependencyClass.getClassLoader() == null) {
            return ConstructorReflection.newInstanceUsingDefaultConstructorIfAvailable(dependencyClass);
        }
        return new TestedObjectCreation(this.injectionState, this, dependencyClass).create();
    }

    @Nonnull
    private Object createAndRegisterConversationInstance() {
        TestConversation conversation = new TestConversation();
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)Conversation.class));
        this.injectionState.saveInstantiatedDependency(injectionPoint, conversation);
        return conversation;
    }

    @Nullable
    private Object createAndRegisterNewInstance(@Nonnull Class<?> typeToInstantiate, @Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint, @Nonnull InjectionProvider injectionProvider) {
        Object dependency = this.createNewInstance(typeToInstantiate);
        if (dependency != null) {
            if (injectionPoint.name == null) {
                injectionPoint = new InjectionPoint(injectionPoint.type, injectionProvider.getName());
            }
            this.registerNewInstance(injector, injectionPoint, dependency);
        }
        return dependency;
    }

    private void registerNewInstance(@Nonnull Injector injector, @Nonnull InjectionPoint injectionPoint, @Nonnull Object dependency) {
        this.injectionState.saveInstantiatedDependency(injectionPoint, dependency);
        Class<?> instantiatedClass = dependency.getClass();
        if (injector.testedClass.isClassFromSameModuleOrSystemAsTestedClass(instantiatedClass)) {
            injector.fillOutDependenciesRecursively(dependency);
            this.injectionState.lifecycleMethods.findLifecycleMethods(instantiatedClass);
            this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(instantiatedClass, dependency);
        }
    }

    public String toString() {
        InjectionProvider parentInjectionProvider;
        String description = "@Tested object \"" + this.testedClass.getSimpleName() + ' ' + this.testedName + '\"';
        if (this.injectionProvider != null && (parentInjectionProvider = this.injectionProvider.parent) != null) {
            description = parentInjectionProvider + "\r\n  of " + description;
        }
        return description;
    }
}

