/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedObject;
import mockit.internal.state.ParameterNames;
import mockit.internal.util.TestMethod;
import mockit.internal.util.Utilities;

final class TestedParameter
extends TestedObject {
    @Nonnull
    private final TestMethod testMethod;
    @Nonnegative
    private final int parameterIndex;

    TestedParameter(@Nonnull InjectionState injectionState, @Nonnull TestMethod testMethod, @Nonnegative int parameterIndex, @Nonnull Tested metadata) {
        super(injectionState, metadata, ParameterNames.getName(testMethod, parameterIndex), testMethod.getParameterType(parameterIndex), testMethod.getParameterClass(parameterIndex));
        this.testMethod = testMethod;
        this.parameterIndex = parameterIndex;
    }

    @Override
    @Nullable
    Object getExistingTestedInstanceIfApplicable(@Nonnull Object testClassInstance) {
        Object testedObject = null;
        if (!this.createAutomatically) {
            Class<?> parameterClass;
            String providedValue = this.metadata.value();
            if (!providedValue.isEmpty() && (testedObject = Utilities.convertFromString(parameterClass = this.testMethod.getParameterClass(this.parameterIndex), providedValue)) != null) {
                this.testMethod.setParameterValue(this.parameterIndex, testedObject);
            }
            this.createAutomatically = testedObject == null;
        }
        return testedObject;
    }

    @Override
    void setInstance(@Nonnull Object testClassInstance, @Nullable Object testedInstance) {
        this.testMethod.setParameterValue(this.parameterIndex, testedInstance);
    }
}

