/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedObject;
import mockit.internal.reflection.FieldReflection;

final class TestedField
extends TestedObject {
    @Nonnull
    private final Field testedField;

    TestedField(@Nonnull InjectionState injectionState, @Nonnull Field field, @Nonnull Tested metadata) {
        super(injectionState, metadata, field.getName(), field.getGenericType(), field.getType());
        this.testedField = field;
    }

    @Override
    boolean alreadyInstantiated(@Nonnull Object testClassInstance) {
        return this.isAvailableDuringSetup() && FieldReflection.getFieldValue(this.testedField, testClassInstance) != null;
    }

    @Override
    @Nullable
    Object getExistingTestedInstanceIfApplicable(@Nonnull Object testClassInstance) {
        Object testedObject = null;
        if (!this.createAutomatically) {
            testedObject = FieldReflection.getFieldValue(this.testedField, testClassInstance);
            this.createAutomatically = testedObject == null && !Modifier.isFinal(this.testedField.getModifiers());
        }
        return testedObject;
    }

    @Override
    void setInstance(@Nonnull Object testClassInstance, @Nullable Object testedInstance) {
        FieldReflection.setFieldValue(this.testedField, testClassInstance, testedInstance);
    }
}

