/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.internal.ClassFile;
import mockit.internal.expectations.transformation.EndOfBlockModifier;
import mockit.internal.startup.Startup;
import mockit.internal.util.ClassNaming;
import mockit.internal.util.VisitInterruptedException;

public final class ExpectationsTransformer
implements ClassFileTransformer {
    @Nonnull
    private final List<String> baseSubclasses = new ArrayList<String>();

    public ExpectationsTransformer(@Nonnull Instrumentation instrumentation) {
        this.baseSubclasses.add("mockit/Expectations");
        this.baseSubclasses.add("mockit/StrictExpectations");
        this.baseSubclasses.add("mockit/Verifications");
        this.baseSubclasses.add("mockit/FullVerifications");
        this.baseSubclasses.add("mockit/VerificationsInOrder");
        this.baseSubclasses.add("mockit/FullVerificationsInOrder");
        Class[] alreadyLoaded = instrumentation.getAllLoadedClasses();
        this.findAndModifyOtherBaseSubclasses(alreadyLoaded);
        this.modifyFinalSubclasses(alreadyLoaded);
    }

    private void findAndModifyOtherBaseSubclasses(@Nonnull Class<?>[] alreadyLoaded) {
        for (Class<?> aClass : alreadyLoaded) {
            if (aClass.getClassLoader() == null || ExpectationsTransformer.isFinalClass(aClass) || !ExpectationsTransformer.isExpectationsOrVerificationsSubclassFromUserCode(aClass)) continue;
            this.modifyInvocationsSubclass(aClass, false);
        }
    }

    private static boolean isFinalClass(@Nonnull Class<?> aClass) {
        return Modifier.isFinal(aClass.getModifiers()) || ClassNaming.isAnonymousClass(aClass);
    }

    private static boolean isExpectationsOrVerificationsSubclassFromUserCode(@Nonnull Class<?> aClass) {
        if (ExpectationsTransformer.isExpectationsOrVerificationsAPIClass(aClass)) {
            return false;
        }
        for (Class<?> superclass = aClass.getSuperclass(); superclass != null && superclass != Object.class && superclass.getClassLoader() != null; superclass = superclass.getSuperclass()) {
            if (!ExpectationsTransformer.isExpectationsOrVerificationsAPIClass(superclass)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpectationsOrVerificationsAPIClass(@Nonnull Class<?> aClass) {
        return "mockit.Expectations mockit.StrictExpectations mockit.Verifications mockit.FullVerifications mockit.VerificationsInOrder mockit.FullVerificationsInOrder".contains(aClass.getName());
    }

    private void modifyFinalSubclasses(@Nonnull Class<?>[] alreadyLoaded) {
        for (Class<?> aClass : alreadyLoaded) {
            if (aClass.getClassLoader() == null || !ExpectationsTransformer.isFinalClass(aClass) || !ExpectationsTransformer.isExpectationsOrVerificationsSubclassFromUserCode(aClass)) continue;
            this.modifyInvocationsSubclass(aClass, true);
        }
    }

    private void modifyInvocationsSubclass(@Nonnull Class<?> aClass, boolean isFinalClass) {
        ClassReader cr = ClassFile.createClassFileReader(aClass);
        byte[] modifiedClassfile = this.modifyInvocationsSubclass(cr, aClass.getClassLoader(), isFinalClass);
        if (modifiedClassfile != null) {
            Startup.redefineMethods(aClass, modifiedClassfile);
        }
    }

    @Nullable
    private byte[] modifyInvocationsSubclass(@Nonnull ClassReader cr, ClassLoader loader, boolean finalClass) {
        EndOfBlockModifier modifier = new EndOfBlockModifier(cr, loader, this.baseSubclasses, finalClass);
        try {
            cr.accept(modifier, 4);
            return modifier.toByteArray();
        }
        catch (VisitInterruptedException visitInterruptedException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        if (classBeingRedefined == null && protectionDomain != null) {
            ClassReader cr = new ClassReader(classfileBuffer);
            String superClassName = cr.getSuperName();
            if (!(this.baseSubclasses.contains(superClassName) || superClassName.endsWith("Expectations") || superClassName.endsWith("Verifications"))) {
                return null;
            }
            boolean finalClass = ClassNaming.isAnonymousClass(className);
            return this.modifyInvocationsSubclass(cr, loader, finalClass);
        }
        return null;
    }
}

