/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;
import mockit.internal.ClassFile;
import mockit.internal.expectations.transformation.InvocationBlockModifier;
import mockit.internal.util.VisitInterruptedException;

final class EndOfBlockModifier
extends ClassVisitor {
    @Nonnull
    private final ClassWriter cw;
    @Nullable
    private final ClassLoader loader;
    @Nonnull
    private final List<String> baseSubclasses;
    private boolean isFinalClass;
    @Nonnull
    private String classDesc;

    EndOfBlockModifier(@Nonnull ClassReader cr, @Nullable ClassLoader loader, @Nonnull List<String> baseSubclasses, boolean isFinalClass) {
        super(new ClassWriter(cr));
        assert (this.cv != null);
        this.cw = (ClassWriter)this.cv;
        this.loader = loader;
        this.baseSubclasses = baseSubclasses;
        this.isFinalClass = isFinalClass;
        this.classDesc = "";
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        if (Modifier.isFinal(access)) {
            this.isFinalClass = true;
        }
        if (!this.isClassWhichShouldBeModified(name, superName)) {
            throw VisitInterruptedException.INSTANCE;
        }
        this.cw.visit(version, access, name, signature, superName, interfaces);
        this.classDesc = name;
    }

    private boolean isClassWhichShouldBeModified(@Nonnull String name, @Nullable String superName) {
        boolean superClassIsKnownInvocationsSubclass;
        if (this.baseSubclasses.contains(name)) {
            return false;
        }
        int i = this.baseSubclasses.indexOf(superName);
        boolean bl = superClassIsKnownInvocationsSubclass = i >= 0;
        if (this.isFinalClass) {
            if (superClassIsKnownInvocationsSubclass) {
                return true;
            }
            SuperClassAnalyser superClassAnalyser = new SuperClassAnalyser(this.loader);
            if (superClassAnalyser.classExtendsInvocationsClass(superName)) {
                return true;
            }
        } else {
            if (superClassIsKnownInvocationsSubclass) {
                this.baseSubclasses.add(name);
                return true;
            }
            SuperClassAnalyser superClassAnalyser = new SuperClassAnalyser(this.loader);
            if (superClassAnalyser.classExtendsInvocationsClass(superName)) {
                this.baseSubclasses.add(name);
                return true;
            }
        }
        return false;
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodWriter mw = this.cw.visitMethod(access, name, desc, signature, exceptions);
        boolean callEndInvocations = this.isFinalClass && "<init>".equals(name);
        return new InvocationBlockModifier(mw, this.classDesc, callEndInvocations);
    }

    private final class SuperClassAnalyser
    extends ClassVisitor {
        @Nullable
        private final ClassLoader loader;
        private boolean classExtendsBaseSubclass;

        private SuperClassAnalyser(ClassLoader loader) {
            this.loader = loader;
        }

        boolean classExtendsInvocationsClass(@Nullable String classOfInterest) {
            if (classOfInterest == null || "java/lang/Object".equals(classOfInterest)) {
                return false;
            }
            ClassReader cr = ClassFile.createClassFileReader(this.loader, classOfInterest);
            try {
                cr.accept(this, 6);
            }
            catch (VisitInterruptedException visitInterruptedException) {
                // empty catch block
            }
            return this.classExtendsBaseSubclass;
        }

        @Override
        public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            this.classExtendsBaseSubclass = EndOfBlockModifier.this.baseSubclasses.contains(superName);
            if (!this.classExtendsBaseSubclass && !"java/lang/Object".equals(superName)) {
                this.classExtendsInvocationsClass(superName);
            }
            throw VisitInterruptedException.INSTANCE;
        }
    }
}

