/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.state.TestRun;

public class TypeRedefinitions {
    @Nonnull
    private final List<Class<?>> targetClasses = new ArrayList(2);
    @Nullable
    protected CaptureOfNewInstances captureOfNewInstances;

    protected TypeRedefinitions() {
    }

    protected final void addTargetClass(@Nonnull MockedType mockedType) {
        Class<?> targetClass = mockedType.getClassType();
        if (targetClass != TypeVariable.class) {
            this.targetClasses.add(targetClass);
            this.addDuplicateTargetClassRepresentingMultipleCapturedSetsOfClasses(mockedType, targetClass);
        }
    }

    private void addDuplicateTargetClassRepresentingMultipleCapturedSetsOfClasses(@Nonnull MockedType mockedType, @Nonnull Class<?> targetClass) {
        int maxInstancesToCapture = mockedType.getMaxInstancesToCapture();
        if (maxInstancesToCapture > 0 && maxInstancesToCapture < Integer.MAX_VALUE) {
            this.targetClasses.add(targetClass);
        }
    }

    @Nonnull
    public final List<Class<?>> getTargetClasses() {
        return this.targetClasses;
    }

    @Nullable
    public final CaptureOfNewInstances getCaptureOfNewInstances() {
        return this.captureOfNewInstances;
    }

    protected static void registerMock(@Nonnull MockedType mockedType, @Nonnull Object mock) {
        TestRun.getExecutingTest().registerMock(mockedType, mock);
    }

    public void cleanUp() {
        if (this.captureOfNewInstances != null) {
            this.captureOfNewInstances.cleanUp();
            this.captureOfNewInstances = null;
        }
    }
}

