/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Invocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.DelegateInvocation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResult;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.reflection.ParameterReflection;
import mockit.internal.state.TestRun;

abstract class DynamicInvocationResult
extends InvocationResult {
    private static final Object[] NO_ARGS = new Object[0];
    @Nonnull
    private final Object targetObject;
    @Nonnull
    final Method methodToInvoke;
    private final boolean hasInvocationParameter;
    private final int numberOfRegularParameters;

    DynamicInvocationResult(@Nonnull Object targetObject, @Nonnull Method methodToInvoke) {
        this.targetObject = targetObject;
        this.methodToInvoke = methodToInvoke;
        Class<?>[] parameters = methodToInvoke.getParameterTypes();
        int n = parameters.length;
        this.hasInvocationParameter = n > 0 && parameters[0] == Invocation.class;
        this.numberOfRegularParameters = this.hasInvocationParameter ? n - 1 : n;
    }

    @Nullable
    public final Object invokeMethodOnTargetObject(@Nullable Object mockOrRealObject, @Nonnull ExpectedInvocation invocation, @Nonnull InvocationConstraints constraints, @Nonnull Object[] args) {
        Object[] delegateArgs = this.numberOfRegularParameters == 0 ? NO_ARGS : args;
        Object result = this.hasInvocationParameter ? this.invokeMethodWithContext(mockOrRealObject, invocation, constraints, args, delegateArgs) : this.executeMethodToInvoke(delegateArgs);
        return result;
    }

    @Nullable
    private Object invokeMethodWithContext(@Nullable Object mockOrRealObject, @Nonnull ExpectedInvocation expectedInvocation, @Nonnull InvocationConstraints constraints, @Nonnull Object[] invokedArgs, @Nonnull Object[] delegateArgs) {
        DelegateInvocation invocation = new DelegateInvocation(mockOrRealObject, invokedArgs, expectedInvocation, constraints);
        Object[] delegateArgsWithInvocation = ParameterReflection.argumentsWithExtraFirstValue(delegateArgs, invocation);
        Class<Void> result = this.executeMethodToInvoke(delegateArgsWithInvocation);
        return expectedInvocation.isConstructor() && TestRun.getExecutingTest().isProceedingIntoRealImplementation() ? Void.class : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Object executeMethodToInvoke(@Nonnull Object[] args) {
        ReentrantLock reentrantLock = RecordAndReplayExecution.RECORD_OR_REPLAY_LOCK;
        if (!reentrantLock.isHeldByCurrentThread()) {
            return MethodReflection.invoke(this.targetObject, this.methodToInvoke, args);
        }
        reentrantLock.unlock();
        try {
            Object t = MethodReflection.invoke(this.targetObject, this.methodToInvoke, args);
            return t;
        }
        finally {
            reentrantLock.lock();
        }
    }
}

